/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.upm.api.util.Option;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;

public abstract class SysCommon {
    public static final String UPM_ON_DEMAND = "atlassian.upm.on.demand";
    public static final String UPM_OD_PVA_BLACKLIST = "atlassian.upm.on.demand.pva.blacklist";
    public static final String ATLASSIAN_CONNECT_XML_BUNDLE_ATTRIBUTE = "Remote-Plugin";
    public static final String ATLASSIAN_CONNECT_JSON_BUNDLE_ATTRIBUTE = "Atlassian-Connect-Addon";
    public static final String ATLASSIAN_CONNECT_PLUGIN_KEY = "com.atlassian.plugins.atlassian-connect-plugin";
    public static final String OLD_ATLASSIAN_CONNECT_PLUGIN_KEY = "com.atlassian.labs.remoteapps-plugin";
    private static final Iterable<String> DEFAULT_BLACKLIST_VALUE = ImmutableList.of((Object)"jira-timesheet-plugin", (Object)"com.balsamiq.jira.plugins.mockups", (Object)"com.balsamiq.confluence.plugins.mockups", (Object)"org.swift.confluence.table");

    public static boolean isOnDemand() {
        return Boolean.getBoolean(UPM_ON_DEMAND);
    }

    public static Iterable<String> getOnDemandPaidViaAtlassianBlacklist() {
        if (!SysCommon.isOnDemand()) {
            return ImmutableList.of();
        }
        return SysCommon.getPluginKeysFromSysProp(UPM_OD_PVA_BLACKLIST, DEFAULT_BLACKLIST_VALUE);
    }

    public static Iterable<String> getPluginKeysFromSysProp(String propKey, Iterable<String> defaultValue) {
        Iterator i$ = Option.option((Object)System.getProperty(propKey)).iterator();
        if (i$.hasNext()) {
            String pluginKeys = (String)i$.next();
            ImmutableList.Builder keys = ImmutableList.builder();
            for (String key : pluginKeys.split(",")) {
                keys.add((Object)key.trim());
            }
            return keys.build();
        }
        return defaultValue;
    }
}

