import re

myencoding = 'utf8'

# from RFC 3986:
#   gen-delims  = ":" / "/" / "?" / "#" / "[" / "]" / "@"
#   sub-delims  = "!" / "$" / "&" / "'" / "(" / ")"
#                     / "*" / "+" / "," / ";" / "="
#   unreserved  = ALPHA / DIGIT / "-" / "." / "_" / "~"

r = re.compile(r"[^\w\-\.\~\:\/\?\#\[\]\@\!\$\&\'\(\)\*\+\,\;\=\%]")

def xss_whitelist(url):
    """
    Filter out chars from URLs that aren't needed and might be used
    to launch an XSS attack.
    For example, without this code, the following URL:
      https://as.example.com:943/__session_start__/%0atest
    would force a line break in the Location reply header
    for redirects.
    """
    return re.sub(r, '', str(url))
