/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.base;

import com.mindskip.xzs.base.SystemCode;

public class RestResponse<T> {
    private int code;
    private String message;
    private T response;

    public RestResponse(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public RestResponse(int code, String message, T response) {
        this.code = code;
        this.message = message;
        this.response = response;
    }

    public static RestResponse fail(Integer code, String msg) {
        return new RestResponse(code.intValue(), msg);
    }

    public static RestResponse ok() {
        SystemCode systemCode = SystemCode.OK;
        return new RestResponse(systemCode.getCode(), systemCode.getMessage());
    }

    public static <F> RestResponse<F> ok(F response) {
        SystemCode systemCode = SystemCode.OK;
        return new RestResponse(systemCode.getCode(), systemCode.getMessage(), response);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResponse() {
        return (T)this.response;
    }

    public void setResponse(T response) {
        this.response = response;
    }
}

