/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.configuration.spring.exception;

import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.base.SystemCode;
import com.mindskip.xzs.utility.ErrorUtil;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionHandle {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandle.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public RestResponse handler(Exception e) {
        logger.error(e.getMessage(), (Throwable)e);
        return new RestResponse(SystemCode.InnerError.getCode(), SystemCode.InnerError.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public RestResponse handler(MethodArgumentNotValidException e) {
        String errorMsg = e.getBindingResult().getAllErrors().stream().map(file -> {
            FieldError fieldError = (FieldError)file;
            return ErrorUtil.parameterErrorFormat((String)fieldError.getField(), (String)fieldError.getDefaultMessage());
        }).collect(Collectors.joining());
        return new RestResponse(SystemCode.ParameterValidError.getCode(), errorMsg);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public RestResponse handler(BindException e) {
        String errorMsg = e.getBindingResult().getAllErrors().stream().map(file -> {
            FieldError fieldError = (FieldError)file;
            return ErrorUtil.parameterErrorFormat((String)fieldError.getField(), (String)fieldError.getDefaultMessage());
        }).collect(Collectors.joining());
        return new RestResponse(SystemCode.ParameterValidError.getCode(), errorMsg);
    }
}

