/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.configuration.spring.security;

import com.mindskip.xzs.context.WebContext;
import com.mindskip.xzs.domain.enums.RoleEnum;
import com.mindskip.xzs.domain.enums.UserStatusEnum;
import com.mindskip.xzs.service.AuthenticationService;
import com.mindskip.xzs.service.UserService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class RestAuthenticationProvider
implements AuthenticationProvider {
    private final AuthenticationService authenticationService;
    private final UserService userService;
    private final WebContext webContext;

    @Autowired
    public RestAuthenticationProvider(AuthenticationService authenticationService, UserService userService, WebContext webContext) {
        this.authenticationService = authenticationService;
        this.userService = userService;
        this.webContext = webContext;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        com.mindskip.xzs.domain.User user = this.userService.getUserByUserName(username);
        if (user == null) {
            throw new UsernameNotFoundException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        boolean result = this.authenticationService.authUser(user, username, password);
        if (!result) {
            throw new BadCredentialsException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        UserStatusEnum userStatusEnum = UserStatusEnum.fromCode((Integer)user.getStatus());
        if (UserStatusEnum.Disable == userStatusEnum) {
            throw new LockedException("\u7528\u6237\u88ab\u7981\u7528");
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        grantedAuthorities.add(new SimpleGrantedAuthority(RoleEnum.fromCode((Integer)user.getRole()).getRoleName()));
        User authUser = new User(user.getUserName(), user.getPassword(), grantedAuthorities);
        return new UsernamePasswordAuthenticationToken((Object)authUser, (Object)authUser.getPassword(), authUser.getAuthorities());
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }
}

