/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.configuration.spring.security;

import com.mindskip.xzs.base.SystemCode;
import com.mindskip.xzs.configuration.spring.security.RestUtil;
import com.mindskip.xzs.domain.UserEventLog;
import com.mindskip.xzs.event.UserEvent;
import com.mindskip.xzs.service.UserService;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class RestAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private final ApplicationEventPublisher eventPublisher;
    private final UserService userService;

    @Autowired
    public RestAuthenticationSuccessHandler(ApplicationEventPublisher eventPublisher, UserService userService) {
        this.eventPublisher = eventPublisher;
        this.userService = userService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        Object object = authentication.getPrincipal();
        if (null != object) {
            User springUser = (User)object;
            com.mindskip.xzs.domain.User user = this.userService.getUserByUserName(springUser.getUsername());
            if (null != user) {
                UserEventLog userEventLog = new UserEventLog(user.getId(), user.getUserName(), user.getRealName(), new Date());
                userEventLog.setContent(user.getUserName() + " \u767b\u5f55\u4e86\u5b66\u4e4b\u601d\u5f00\u6e90\u8003\u8bd5\u7cfb\u7edf");
                this.eventPublisher.publishEvent((ApplicationEvent)new UserEvent(userEventLog));
                com.mindskip.xzs.domain.User newUser = new com.mindskip.xzs.domain.User();
                newUser.setUserName(user.getUserName());
                newUser.setImagePath(user.getImagePath());
                RestUtil.response((HttpServletResponse)response, (int)SystemCode.OK.getCode(), (String)SystemCode.OK.getMessage(), (Object)newUser);
            }
        } else {
            RestUtil.response((HttpServletResponse)response, (int)SystemCode.UNAUTHORIZED.getCode(), (String)SystemCode.UNAUTHORIZED.getMessage());
        }
    }
}

