/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.configuration.spring.wx;

import com.mindskip.xzs.base.SystemCode;
import com.mindskip.xzs.configuration.spring.security.RestUtil;
import com.mindskip.xzs.context.WxContext;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.UserToken;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.service.UserTokenService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TokenHandlerInterceptor
implements HandlerInterceptor {
    private final UserTokenService userTokenService;
    private final UserService userService;
    private final WxContext wxContext;

    @Autowired
    public TokenHandlerInterceptor(UserTokenService userTokenService, UserService userService, WxContext wxContext) {
        this.userTokenService = userTokenService;
        this.userService = userService;
        this.wxContext = wxContext;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader("token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            RestUtil.response((HttpServletResponse)response, (SystemCode)SystemCode.UNAUTHORIZED);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            RestUtil.response((HttpServletResponse)response, (SystemCode)SystemCode.UNAUTHORIZED);
            return false;
        }
        if (token.length() != 36) {
            RestUtil.response((HttpServletResponse)response, (SystemCode)SystemCode.UNAUTHORIZED);
            return false;
        }
        UserToken userToken = this.userTokenService.getToken(token);
        if (null == userToken) {
            RestUtil.response((HttpServletResponse)response, (SystemCode)SystemCode.UNAUTHORIZED);
            return false;
        }
        Date now = new Date();
        User user = this.userService.getUserByUserName(userToken.getUserName());
        if (now.before(userToken.getEndTime())) {
            this.wxContext.setContext(user, userToken);
            return true;
        }
        UserToken refreshToken = this.userTokenService.insertUserToken(user);
        RestUtil.response((HttpServletResponse)response, (int)SystemCode.AccessTokenError.getCode(), (String)SystemCode.AccessTokenError.getMessage(), (Object)refreshToken.getToken());
        return false;
    }
}

