/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.context;

import com.mindskip.xzs.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class WebContext {
    private static final String USER_ATTRIBUTES = "USER_ATTRIBUTES";
    private final UserService userService;

    @Autowired
    public WebContext(UserService userService) {
        this.userService = userService;
    }

    public void setCurrentUser(com.mindskip.xzs.domain.User user) {
        RequestContextHolder.currentRequestAttributes().setAttribute(USER_ATTRIBUTES, (Object)user, 0);
    }

    public com.mindskip.xzs.domain.User getCurrentUser() {
        com.mindskip.xzs.domain.User user = (com.mindskip.xzs.domain.User)RequestContextHolder.currentRequestAttributes().getAttribute(USER_ATTRIBUTES, 0);
        if (null != user) {
            return user;
        }
        User springUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (null == springUser) {
            return null;
        }
        user = this.userService.getUserByUserName(springUser.getUsername());
        if (null != user) {
            this.setCurrentUser(user);
        }
        return user;
    }
}

