/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.admin;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.domain.Subject;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.service.ExamPaperAnswerService;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.paper.ExamPaperAnswerPageRequestVM;
import com.mindskip.xzs.viewmodel.student.exampaper.ExamPaperAnswerPageResponseVM;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="AdminExamPaperAnswerController")
@RequestMapping(value={"/api/admin/examPaperAnswer"})
public class ExamPaperAnswerController
extends BaseApiController {
    private final ExamPaperAnswerService examPaperAnswerService;
    private final SubjectService subjectService;
    private final UserService userService;

    @Autowired
    public ExamPaperAnswerController(ExamPaperAnswerService examPaperAnswerService, SubjectService subjectService, UserService userService) {
        this.examPaperAnswerService = examPaperAnswerService;
        this.subjectService = subjectService;
        this.userService = userService;
    }

    @RequestMapping(value={"/page"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<ExamPaperAnswerPageResponseVM>> pageJudgeList(@RequestBody ExamPaperAnswerPageRequestVM model) {
        PageInfo pageInfo = this.examPaperAnswerService.adminPage(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, e -> {
            ExamPaperAnswerPageResponseVM vm = (ExamPaperAnswerPageResponseVM)modelMapper.map(e, ExamPaperAnswerPageResponseVM.class);
            Subject subject = (Subject)this.subjectService.selectById(vm.getSubjectId());
            vm.setDoTime(ExamUtil.secondToVM((Integer)e.getDoTime()));
            vm.setSystemScore(ExamUtil.scoreToVM((Integer)e.getSystemScore()));
            vm.setUserScore(ExamUtil.scoreToVM((Integer)e.getUserScore()));
            vm.setPaperScore(ExamUtil.scoreToVM((Integer)e.getPaperScore()));
            vm.setSubjectName(subject.getName());
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)e.getCreateTime()));
            User user = (User)this.userService.selectById(e.getCreateUser());
            vm.setUserName(user.getUserName());
            return vm;
        });
        return RestResponse.ok((Object)page);
    }
}

