/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.admin;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.domain.Message;
import com.mindskip.xzs.domain.MessageUser;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.service.MessageService;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.message.MessagePageRequestVM;
import com.mindskip.xzs.viewmodel.admin.message.MessageResponseVM;
import com.mindskip.xzs.viewmodel.admin.message.MessageSendVM;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="AdminMessageController")
@RequestMapping(value={"/api/admin/message"})
public class MessageController
extends BaseApiController {
    private final MessageService messageService;
    private final UserService userService;

    @Autowired
    public MessageController(MessageService messageService, UserService userService) {
        this.messageService = messageService;
        this.userService = userService;
    }

    @RequestMapping(value={"/page"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<MessageResponseVM>> pageList(@RequestBody MessagePageRequestVM model) {
        PageInfo pageInfo = this.messageService.page(model);
        List ids = pageInfo.getList().stream().map(d -> d.getId()).collect(Collectors.toList());
        List messageUsers = ids.size() == 0 ? null : this.messageService.selectByMessageIds(ids);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, m -> {
            MessageResponseVM vm = (MessageResponseVM)modelMapper.map(m, MessageResponseVM.class);
            String receives = messageUsers.stream().filter(d -> d.getMessageId().equals(m.getId())).map(d -> d.getReceiveUserName()).collect(Collectors.joining(","));
            vm.setReceives(receives);
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)m.getCreateTime()));
            return vm;
        });
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    public RestResponse send(@RequestBody @Valid MessageSendVM model) {
        User user = this.getCurrentUser();
        List receiveUser = this.userService.selectByIds(model.getReceiveUserIds());
        Date now = new Date();
        Message message = new Message();
        message.setTitle(model.getTitle());
        message.setContent(model.getContent());
        message.setCreateTime(now);
        message.setReadCount(Integer.valueOf(0));
        message.setReceiveUserCount(Integer.valueOf(receiveUser.size()));
        message.setSendUserId(user.getId());
        message.setSendUserName(user.getUserName());
        message.setSendRealName(user.getRealName());
        List messageUsers = receiveUser.stream().map(d -> {
            MessageUser messageUser = new MessageUser();
            messageUser.setCreateTime(now);
            messageUser.setReaded(Boolean.valueOf(false));
            messageUser.setReceiveRealName(d.getRealName());
            messageUser.setReceiveUserId(d.getId());
            messageUser.setReceiveUserName(d.getUserName());
            return messageUser;
        }).collect(Collectors.toList());
        this.messageService.sendMessage(message, messageUsers);
        return RestResponse.ok();
    }
}

