/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.admin;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.base.SystemCode;
import com.mindskip.xzs.domain.Question;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.enums.QuestionTypeEnum;
import com.mindskip.xzs.domain.question.QuestionObject;
import com.mindskip.xzs.service.QuestionService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ErrorUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.HtmlUtil;
import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.question.QuestionEditRequestVM;
import com.mindskip.xzs.viewmodel.admin.question.QuestionPageRequestVM;
import com.mindskip.xzs.viewmodel.admin.question.QuestionResponseVM;
import java.util.Date;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="AdminQuestionController")
@RequestMapping(value={"/api/admin/question"})
public class QuestionController
extends BaseApiController {
    private final QuestionService questionService;
    private final TextContentService textContentService;

    @Autowired
    public QuestionController(QuestionService questionService, TextContentService textContentService) {
        this.questionService = questionService;
        this.textContentService = textContentService;
    }

    @RequestMapping(value={"/page"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<QuestionResponseVM>> pageList(@RequestBody QuestionPageRequestVM model) {
        PageInfo pageInfo = this.questionService.page(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, q -> {
            QuestionResponseVM vm = (QuestionResponseVM)modelMapper.map(q, QuestionResponseVM.class);
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)q.getCreateTime()));
            vm.setScore(ExamUtil.scoreToVM((Integer)q.getScore()));
            TextContent textContent = (TextContent)this.textContentService.selectById(q.getInfoTextContentId());
            QuestionObject questionObject = (QuestionObject)JsonUtil.toJsonObject((String)textContent.getContent(), QuestionObject.class);
            String clearHtml = HtmlUtil.clear((String)questionObject.getTitleContent());
            vm.setShortTitle(clearHtml);
            return vm;
        });
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public RestResponse edit(@RequestBody @Valid QuestionEditRequestVM model) {
        RestResponse validQuestionEditRequestResult = this.validQuestionEditRequestVM(model);
        if (validQuestionEditRequestResult.getCode() != SystemCode.OK.getCode()) {
            return validQuestionEditRequestResult;
        }
        if (null == model.getId()) {
            this.questionService.insertFullQuestion(model, this.getCurrentUser().getId());
        } else {
            this.questionService.updateFullQuestion(model);
        }
        return RestResponse.ok();
    }

    @RequestMapping(value={"/select/{id}"}, method={RequestMethod.POST})
    public RestResponse<QuestionEditRequestVM> select(@PathVariable Integer id) {
        QuestionEditRequestVM newVM = this.questionService.getQuestionEditRequestVM(id);
        return RestResponse.ok((Object)newVM);
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.POST})
    public RestResponse delete(@PathVariable Integer id) {
        Question question = (Question)this.questionService.selectById(id);
        question.setDeleted(Boolean.valueOf(true));
        this.questionService.updateByIdFilter((Object)question);
        return RestResponse.ok();
    }

    private RestResponse validQuestionEditRequestVM(QuestionEditRequestVM model) {
        Integer questionScore;
        Integer fillSumScore;
        boolean requireCorrect;
        int qType = model.getQuestionType();
        boolean bl = requireCorrect = qType == QuestionTypeEnum.SingleChoice.getCode() || qType == QuestionTypeEnum.TrueFalse.getCode();
        if (requireCorrect && StringUtils.isBlank((CharSequence)model.getCorrect())) {
            String errorMsg = ErrorUtil.parameterErrorFormat((String)"correct", (String)"\u4e0d\u80fd\u4e3a\u7a7a");
            return new RestResponse(SystemCode.ParameterValidError.getCode(), errorMsg);
        }
        if (qType == QuestionTypeEnum.GapFilling.getCode() && !(fillSumScore = Integer.valueOf(model.getItems().stream().mapToInt(d -> ExamUtil.scoreFromVM((String)d.getScore())).sum())).equals(questionScore = ExamUtil.scoreFromVM((String)model.getScore()))) {
            String errorMsg = ErrorUtil.parameterErrorFormat((String)"score", (String)"\u7a7a\u5206\u6570\u548c\u4e0e\u9898\u76ee\u603b\u5206\u4e0d\u76f8\u7b49");
            return new RestResponse(SystemCode.ParameterValidError.getCode(), errorMsg);
        }
        return RestResponse.ok();
    }
}

