/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.admin;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.enums.UserStatusEnum;
import com.mindskip.xzs.domain.other.KeyValue;
import com.mindskip.xzs.service.AuthenticationService;
import com.mindskip.xzs.service.UserEventLogService;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.user.UserCreateVM;
import com.mindskip.xzs.viewmodel.admin.user.UserEventLogVM;
import com.mindskip.xzs.viewmodel.admin.user.UserEventPageRequestVM;
import com.mindskip.xzs.viewmodel.admin.user.UserPageRequestVM;
import com.mindskip.xzs.viewmodel.admin.user.UserResponseVM;
import com.mindskip.xzs.viewmodel.admin.user.UserUpdateVM;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="AdminUserController")
@RequestMapping(value={"/api/admin/user"})
public class UserController
extends BaseApiController {
    private final UserService userService;
    private final UserEventLogService userEventLogService;
    private final AuthenticationService authenticationService;

    @Autowired
    public UserController(UserService userService, UserEventLogService userEventLogService, AuthenticationService authenticationService) {
        this.userService = userService;
        this.userEventLogService = userEventLogService;
        this.authenticationService = authenticationService;
    }

    @RequestMapping(value={"/page/list"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<UserResponseVM>> pageList(@RequestBody UserPageRequestVM model) {
        PageInfo pageInfo = this.userService.userPage(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, d -> UserResponseVM.from((User)d));
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/event/page/list"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<UserEventLogVM>> eventPageList(@RequestBody UserEventPageRequestVM model) {
        PageInfo pageInfo = this.userEventLogService.page(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, d -> {
            UserEventLogVM vm = (UserEventLogVM)modelMapper.map(d, UserEventLogVM.class);
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)d.getCreateTime()));
            return vm;
        });
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/select/{id}"}, method={RequestMethod.POST})
    public RestResponse<UserResponseVM> select(@PathVariable Integer id) {
        User user = this.userService.getUserById(id);
        UserResponseVM userVm = UserResponseVM.from((User)user);
        return RestResponse.ok((Object)userVm);
    }

    @RequestMapping(value={"/current"}, method={RequestMethod.POST})
    public RestResponse<UserResponseVM> current() {
        User user = this.getCurrentUser();
        UserResponseVM userVm = UserResponseVM.from((User)user);
        return RestResponse.ok((Object)userVm);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public RestResponse<User> edit(@RequestBody @Valid UserCreateVM model) {
        if (model.getId() == null) {
            User existUser = this.userService.getUserByUserName(model.getUserName());
            if (null != existUser) {
                return new RestResponse(2, "\u7528\u6237\u5df2\u5b58\u5728");
            }
            if (StringUtils.isBlank((CharSequence)model.getPassword())) {
                return new RestResponse(3, "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isBlank((CharSequence)model.getBirthDay())) {
            model.setBirthDay(null);
        }
        User user = (User)modelMapper.map((Object)model, User.class);
        if (model.getId() == null) {
            String encodePwd = this.authenticationService.pwdEncode(model.getPassword());
            user.setPassword(encodePwd);
            user.setUserUuid(UUID.randomUUID().toString());
            user.setCreateTime(new Date());
            user.setLastActiveTime(new Date());
            user.setDeleted(Boolean.valueOf(false));
            this.userService.insertByFilter((Object)user);
        } else {
            if (!StringUtils.isBlank((CharSequence)model.getPassword())) {
                String encodePwd = this.authenticationService.pwdEncode(model.getPassword());
                user.setPassword(encodePwd);
            }
            user.setModifyTime(new Date());
            this.userService.updateByIdFilter((Object)user);
        }
        return RestResponse.ok((Object)user);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public RestResponse update(@RequestBody @Valid UserUpdateVM model) {
        User user = (User)this.userService.selectById(this.getCurrentUser().getId());
        modelMapper.map((Object)model, (Object)user);
        user.setModifyTime(new Date());
        this.userService.updateByIdFilter((Object)user);
        return RestResponse.ok();
    }

    @RequestMapping(value={"/changeStatus/{id}"}, method={RequestMethod.POST})
    public RestResponse<Integer> changeStatus(@PathVariable Integer id) {
        User user = this.userService.getUserById(id);
        UserStatusEnum userStatusEnum = UserStatusEnum.fromCode((Integer)user.getStatus());
        Integer newStatus = userStatusEnum == UserStatusEnum.Enable ? UserStatusEnum.Disable.getCode() : UserStatusEnum.Enable.getCode();
        user.setStatus(newStatus);
        user.setModifyTime(new Date());
        this.userService.updateByIdFilter((Object)user);
        return RestResponse.ok((Object)newStatus);
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.POST})
    public RestResponse delete(@PathVariable Integer id) {
        User user = this.userService.getUserById(id);
        user.setDeleted(Boolean.valueOf(true));
        this.userService.updateByIdFilter((Object)user);
        return RestResponse.ok();
    }

    @RequestMapping(value={"/selectByUserName"}, method={RequestMethod.POST})
    public RestResponse<List<KeyValue>> selectByUserName(@RequestBody String userName) {
        List keyValues = this.userService.selectByUserName(userName);
        return RestResponse.ok((Object)keyValues);
    }
}

