/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.student;

import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.service.FileUpload;
import com.mindskip.xzs.service.UserService;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RequestMapping(value={"/api/student/upload"})
@RestController(value="StudentUploadController")
public class UploadController
extends BaseApiController {
    private final FileUpload fileUpload;
    private final UserService userService;

    @Autowired
    public UploadController(FileUpload fileUpload, UserService userService) {
        this.fileUpload = fileUpload;
        this.userService = userService;
    }

    @RequestMapping(value={"/image"})
    @ResponseBody
    public RestResponse questionUploadAndReadExcel(HttpServletRequest request) {
        RestResponse restResponse;
        block8: {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile multipartFile = multipartHttpServletRequest.getFile("file");
            long attachSize = multipartFile.getSize();
            String imgName = multipartFile.getOriginalFilename();
            InputStream inputStream = multipartFile.getInputStream();
            try {
                String filePath = this.fileUpload.uploadFile(inputStream, attachSize, imgName);
                this.userService.changePicture(this.getCurrentUser(), filePath);
                restResponse = RestResponse.ok((Object)filePath);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return RestResponse.fail((Integer)2, (String)e.getMessage());
                }
            }
            inputStream.close();
        }
        return restResponse;
    }
}

