/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.wx.student;

import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.controller.wx.BaseWXApiController;
import com.mindskip.xzs.domain.TaskExamCustomerAnswer;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.enums.ExamPaperTypeEnum;
import com.mindskip.xzs.domain.task.TaskItemAnswerObject;
import com.mindskip.xzs.domain.task.TaskItemObject;
import com.mindskip.xzs.service.ExamPaperService;
import com.mindskip.xzs.service.TaskExamCustomerAnswerService;
import com.mindskip.xzs.service.TaskExamService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.viewmodel.student.dashboard.IndexVM;
import com.mindskip.xzs.viewmodel.student.dashboard.PaperFilter;
import com.mindskip.xzs.viewmodel.student.dashboard.PaperInfoVM;
import com.mindskip.xzs.viewmodel.student.dashboard.TaskItemPaperVm;
import com.mindskip.xzs.viewmodel.student.dashboard.TaskItemVm;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WXStudentDashboardController")
@RequestMapping(value={"/api/wx/student/dashboard"})
@ResponseBody
public class DashboardController
extends BaseWXApiController {
    private final ExamPaperService examPaperService;
    private final TextContentService textContentService;
    private final TaskExamService taskExamService;
    private final TaskExamCustomerAnswerService taskExamCustomerAnswerService;

    @Autowired
    public DashboardController(ExamPaperService examPaperService, TextContentService textContentService, TaskExamService taskExamService, TaskExamCustomerAnswerService taskExamCustomerAnswerService) {
        this.examPaperService = examPaperService;
        this.textContentService = textContentService;
        this.taskExamService = taskExamService;
        this.taskExamCustomerAnswerService = taskExamCustomerAnswerService;
    }

    @RequestMapping(value={"/index"}, method={RequestMethod.POST})
    public RestResponse<IndexVM> index() {
        IndexVM indexVM = new IndexVM();
        User user = this.getCurrentUser();
        PaperFilter fixedPaperFilter = new PaperFilter();
        fixedPaperFilter.setGradeLevel(user.getUserLevel());
        fixedPaperFilter.setExamPaperType(Integer.valueOf(ExamPaperTypeEnum.Fixed.getCode()));
        indexVM.setFixedPaper(this.examPaperService.indexPaper(fixedPaperFilter));
        PaperFilter timeLimitPaperFilter = new PaperFilter();
        timeLimitPaperFilter.setDateTime(new Date());
        timeLimitPaperFilter.setGradeLevel(user.getUserLevel());
        timeLimitPaperFilter.setExamPaperType(Integer.valueOf(ExamPaperTypeEnum.TimeLimit.getCode()));
        List limitPaper = this.examPaperService.indexPaper(timeLimitPaperFilter);
        List paperInfoVMS = limitPaper.stream().map(d -> {
            PaperInfoVM vm = (PaperInfoVM)modelMapper.map(d, PaperInfoVM.class);
            vm.setStartTime(DateTimeUtil.dateFormat((Date)d.getLimitStartTime()));
            vm.setEndTime(DateTimeUtil.dateFormat((Date)d.getLimitEndTime()));
            return vm;
        }).collect(Collectors.toList());
        indexVM.setTimeLimitPaper(paperInfoVMS);
        return RestResponse.ok((Object)indexVM);
    }

    @RequestMapping(value={"/task"}, method={RequestMethod.POST})
    public RestResponse<List<TaskItemVm>> task() {
        User user = this.getCurrentUser();
        List taskExams = this.taskExamService.getByGradeLevel(user.getUserLevel());
        if (taskExams.size() == 0) {
            return RestResponse.ok(new ArrayList());
        }
        List tIds = taskExams.stream().map(taskExam -> taskExam.getId()).collect(Collectors.toList());
        List taskExamCustomerAnswers = this.taskExamCustomerAnswerService.selectByTUid(tIds, user.getId());
        List vm = taskExams.stream().map(t -> {
            TaskItemVm itemVm = new TaskItemVm();
            itemVm.setId(t.getId());
            itemVm.setTitle(t.getTitle());
            TaskExamCustomerAnswer taskExamCustomerAnswer = taskExamCustomerAnswers.stream().filter(tc -> tc.getTaskExamId().equals(t.getId())).findFirst().orElse(null);
            List paperItemVMS = this.getTaskItemPaperVm(t.getFrameTextContentId(), taskExamCustomerAnswer);
            itemVm.setPaperItems(paperItemVMS);
            return itemVm;
        }).collect(Collectors.toList());
        return RestResponse.ok(vm);
    }

    private List<TaskItemPaperVm> getTaskItemPaperVm(Integer tFrameId, TaskExamCustomerAnswer taskExamCustomerAnswers) {
        TextContent textContent = (TextContent)this.textContentService.selectById(tFrameId);
        List paperItems = JsonUtil.toJsonListObject((String)textContent.getContent(), TaskItemObject.class);
        List answerPaperItems = null;
        if (null != taskExamCustomerAnswers) {
            TextContent answerTextContent = (TextContent)this.textContentService.selectById(taskExamCustomerAnswers.getTextContentId());
            answerPaperItems = JsonUtil.toJsonListObject((String)answerTextContent.getContent(), TaskItemAnswerObject.class);
        }
        List finalAnswerPaperItems = answerPaperItems;
        return paperItems.stream().map(p -> {
            TaskItemPaperVm ivm = new TaskItemPaperVm();
            ivm.setExamPaperId(p.getExamPaperId());
            ivm.setExamPaperName(p.getExamPaperName());
            if (null != finalAnswerPaperItems) {
                finalAnswerPaperItems.stream().filter(a -> a.getExamPaperId().equals(p.getExamPaperId())).findFirst().ifPresent(a -> {
                    ivm.setExamPaperAnswerId(a.getExamPaperAnswerId());
                    ivm.setStatus(a.getStatus());
                });
            }
            return ivm;
        }).collect(Collectors.toList());
    }
}

