/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.wx.student;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.controller.wx.BaseWXApiController;
import com.mindskip.xzs.domain.ExamPaperAnswer;
import com.mindskip.xzs.domain.ExamPaperAnswerInfo;
import com.mindskip.xzs.domain.Subject;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.UserEventLog;
import com.mindskip.xzs.domain.enums.QuestionTypeEnum;
import com.mindskip.xzs.event.CalculateExamPaperAnswerCompleteEvent;
import com.mindskip.xzs.event.UserEvent;
import com.mindskip.xzs.service.ExamPaperAnswerService;
import com.mindskip.xzs.service.ExamPaperService;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.exam.ExamPaperEditRequestVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperReadVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperSubmitItemVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperSubmitVM;
import com.mindskip.xzs.viewmodel.student.exampaper.ExamPaperAnswerPageResponseVM;
import com.mindskip.xzs.viewmodel.student.exampaper.ExamPaperAnswerPageVM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WXStudentExamPaperAnswerController")
@RequestMapping(value={"/api/wx/student/exampaper/answer"})
@ResponseBody
public class ExamPaperAnswerController
extends BaseWXApiController {
    private final ExamPaperAnswerService examPaperAnswerService;
    private final SubjectService subjectService;
    private final ApplicationEventPublisher eventPublisher;
    private final ExamPaperService examPaperService;

    @Autowired
    public ExamPaperAnswerController(ExamPaperAnswerService examPaperAnswerService, SubjectService subjectService, ApplicationEventPublisher eventPublisher, ExamPaperService examPaperService) {
        this.examPaperAnswerService = examPaperAnswerService;
        this.subjectService = subjectService;
        this.eventPublisher = eventPublisher;
        this.examPaperService = examPaperService;
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<ExamPaperAnswerPageResponseVM>> pageList(@Valid ExamPaperAnswerPageVM model) {
        model.setCreateUser(this.getCurrentUser().getId());
        PageInfo pageInfo = this.examPaperAnswerService.studentPage(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, e -> {
            ExamPaperAnswerPageResponseVM vm = (ExamPaperAnswerPageResponseVM)modelMapper.map(e, ExamPaperAnswerPageResponseVM.class);
            Subject subject = (Subject)this.subjectService.selectById(vm.getSubjectId());
            vm.setDoTime(ExamUtil.secondToVM((Integer)e.getDoTime()));
            vm.setSystemScore(ExamUtil.scoreToVM((Integer)e.getSystemScore()));
            vm.setUserScore(ExamUtil.scoreToVM((Integer)e.getUserScore()));
            vm.setPaperScore(ExamUtil.scoreToVM((Integer)e.getPaperScore()));
            vm.setSubjectName(subject.getName());
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)e.getCreateTime()));
            return vm;
        });
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/answerSubmit"}, method={RequestMethod.POST})
    public RestResponse answerSubmit(HttpServletRequest request) {
        User user;
        ExamPaperSubmitVM examPaperSubmitVM = this.requestToExamPaperSubmitVM(request);
        ExamPaperAnswerInfo examPaperAnswerInfo = this.examPaperAnswerService.calculateExamPaperAnswer(examPaperSubmitVM, user = this.getCurrentUser());
        if (null == examPaperAnswerInfo) {
            return RestResponse.fail((Integer)2, (String)"\u8bd5\u5377\u4e0d\u80fd\u91cd\u590d\u505a");
        }
        ExamPaperAnswer examPaperAnswer = examPaperAnswerInfo.getExamPaperAnswer();
        Integer userScore = examPaperAnswer.getUserScore();
        String scoreVm = ExamUtil.scoreToVM((Integer)userScore);
        UserEventLog userEventLog = new UserEventLog(user.getId(), user.getUserName(), user.getRealName(), new Date());
        String content = user.getUserName() + " \u63d0\u4ea4\u8bd5\u5377\uff1a" + examPaperAnswerInfo.getExamPaper().getName() + " \u5f97\u5206\uff1a" + scoreVm + " \u8017\u65f6\uff1a" + ExamUtil.secondToVM((Integer)examPaperAnswer.getDoTime());
        userEventLog.setContent(content);
        this.eventPublisher.publishEvent((ApplicationEvent)new CalculateExamPaperAnswerCompleteEvent(examPaperAnswerInfo));
        this.eventPublisher.publishEvent((ApplicationEvent)new UserEvent(userEventLog));
        return RestResponse.ok((Object)scoreVm);
    }

    private ExamPaperSubmitVM requestToExamPaperSubmitVM(HttpServletRequest request) {
        ExamPaperSubmitVM examPaperSubmitVM = new ExamPaperSubmitVM();
        examPaperSubmitVM.setId(Integer.valueOf(Integer.parseInt(request.getParameter("id"))));
        examPaperSubmitVM.setDoTime(Integer.valueOf(Integer.parseInt(request.getParameter("doTime"))));
        List parameterNames = Collections.list(request.getParameterNames()).stream().filter(n -> n.contains("_")).collect(Collectors.toList());
        Map<String, List<String>> questionGroup = parameterNames.stream().collect(Collectors.groupingBy(p -> p.substring(0, p.indexOf("_"))));
        ArrayList answerItems = new ArrayList();
        questionGroup.forEach((k, v) -> {
            ExamPaperSubmitItemVM examPaperSubmitItemVM = new ExamPaperSubmitItemVM();
            String p = (String)v.get(0);
            String[] keys = p.split("_");
            examPaperSubmitItemVM.setQuestionId(Integer.valueOf(Integer.parseInt(keys[1])));
            examPaperSubmitItemVM.setItemOrder(Integer.valueOf(Integer.parseInt(keys[0])));
            QuestionTypeEnum typeEnum = QuestionTypeEnum.fromCode((Integer)Integer.parseInt(keys[2]));
            if (v.size() == 1) {
                String content = request.getParameter(p);
                examPaperSubmitItemVM.setContent(content);
                if (typeEnum == QuestionTypeEnum.MultipleChoice) {
                    examPaperSubmitItemVM.setContentArray(Arrays.asList(content.split(",")));
                }
            } else {
                List answers = v.stream().sorted(Comparator.comparingInt(ExamUtil::lastNum)).map(inputKey -> request.getParameter(inputKey)).collect(Collectors.toList());
                examPaperSubmitItemVM.setContentArray(answers);
            }
            answerItems.add(examPaperSubmitItemVM);
        });
        examPaperSubmitVM.setAnswerItems(answerItems);
        return examPaperSubmitVM;
    }

    @PostMapping(value={"/read/{id}"})
    public RestResponse<ExamPaperReadVM> read(@PathVariable Integer id) {
        ExamPaperReadVM vm = new ExamPaperReadVM();
        ExamPaperAnswer examPaperAnswer = (ExamPaperAnswer)this.examPaperAnswerService.selectById(id);
        ExamPaperEditRequestVM paper = this.examPaperService.examPaperToVM(examPaperAnswer.getExamPaperId());
        ExamPaperSubmitVM answer = this.examPaperAnswerService.examPaperAnswerToVM(examPaperAnswer.getId());
        vm.setPaper(paper);
        vm.setAnswer(answer);
        return RestResponse.ok((Object)vm);
    }
}

