/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.wx.student;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.controller.wx.BaseWXApiController;
import com.mindskip.xzs.domain.Subject;
import com.mindskip.xzs.service.ExamPaperService;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.exam.ExamPaperEditRequestVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperPageResponseVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperPageVM;
import java.util.Date;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WXStudentExamController")
@RequestMapping(value={"/api/wx/student/exampaper"})
@ResponseBody
public class ExamPaperController
extends BaseWXApiController {
    private final ExamPaperService examPaperService;
    private final SubjectService subjectService;

    @Autowired
    public ExamPaperController(ExamPaperService examPaperService, SubjectService subjectService) {
        this.examPaperService = examPaperService;
        this.subjectService = subjectService;
    }

    @RequestMapping(value={"/select/{id}"}, method={RequestMethod.POST})
    public RestResponse<ExamPaperEditRequestVM> select(@PathVariable Integer id) {
        ExamPaperEditRequestVM vm = this.examPaperService.examPaperToVM(id);
        return RestResponse.ok((Object)vm);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<ExamPaperPageResponseVM>> pageList(@Valid ExamPaperPageVM model) {
        model.setLevelId(this.getCurrentUser().getUserLevel());
        PageInfo pageInfo = this.examPaperService.studentPage(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, e -> {
            ExamPaperPageResponseVM vm = (ExamPaperPageResponseVM)modelMapper.map(e, ExamPaperPageResponseVM.class);
            Subject subject = (Subject)this.subjectService.selectById(vm.getSubjectId());
            vm.setSubjectName(subject.getName());
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)e.getCreateTime()));
            return vm;
        });
        return RestResponse.ok((Object)page);
    }
}

