/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.wx.student;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.controller.wx.BaseWXApiController;
import com.mindskip.xzs.domain.Message;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.UserEventLog;
import com.mindskip.xzs.domain.enums.RoleEnum;
import com.mindskip.xzs.domain.enums.UserStatusEnum;
import com.mindskip.xzs.event.UserEvent;
import com.mindskip.xzs.service.AuthenticationService;
import com.mindskip.xzs.service.MessageService;
import com.mindskip.xzs.service.UserEventLogService;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.student.user.MessageRequestVM;
import com.mindskip.xzs.viewmodel.student.user.MessageResponseVM;
import com.mindskip.xzs.viewmodel.student.user.UserEventLogVM;
import com.mindskip.xzs.viewmodel.student.user.UserRegisterVM;
import com.mindskip.xzs.viewmodel.student.user.UserResponseVM;
import com.mindskip.xzs.viewmodel.student.user.UserUpdateVM;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WXStudentUserController")
@RequestMapping(value={"/api/wx/student/user"})
@ResponseBody
public class UserController
extends BaseWXApiController {
    private final UserService userService;
    private final UserEventLogService userEventLogService;
    private final MessageService messageService;
    private final AuthenticationService authenticationService;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public UserController(UserService userService, UserEventLogService userEventLogService, MessageService messageService, AuthenticationService authenticationService, ApplicationEventPublisher eventPublisher) {
        this.userService = userService;
        this.userEventLogService = userEventLogService;
        this.messageService = messageService;
        this.authenticationService = authenticationService;
        this.eventPublisher = eventPublisher;
    }

    @RequestMapping(value={"/current"}, method={RequestMethod.POST})
    public RestResponse<UserResponseVM> current() {
        User user = this.getCurrentUser();
        UserResponseVM userVm = UserResponseVM.from((User)user);
        userVm.setBirthDay(DateTimeUtil.dateShortFormat((Date)user.getBirthDay()));
        return RestResponse.ok((Object)userVm);
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public RestResponse register(@Valid UserRegisterVM model) {
        User existUser = this.userService.getUserByUserName(model.getUserName());
        if (null != existUser) {
            return new RestResponse(2, "\u7528\u6237\u5df2\u5b58\u5728");
        }
        User user = (User)modelMapper.map((Object)model, User.class);
        String encodePwd = this.authenticationService.pwdEncode(model.getPassword());
        user.setUserUuid(UUID.randomUUID().toString());
        user.setPassword(encodePwd);
        user.setRole(Integer.valueOf(RoleEnum.STUDENT.getCode()));
        user.setStatus(Integer.valueOf(UserStatusEnum.Enable.getCode()));
        user.setLastActiveTime(new Date());
        user.setCreateTime(new Date());
        user.setDeleted(Boolean.valueOf(false));
        this.userService.insertByFilter((Object)user);
        UserEventLog userEventLog = new UserEventLog(user.getId(), user.getUserName(), user.getRealName(), new Date());
        userEventLog.setContent("\u6b22\u8fce " + user.getUserName() + " \u6ce8\u518c\u6765\u5230\u5b66\u4e4b\u601d\u5f00\u6e90\u8003\u8bd5\u7cfb\u7edf");
        this.eventPublisher.publishEvent((ApplicationEvent)new UserEvent(userEventLog));
        return RestResponse.ok();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public RestResponse<UserResponseVM> update(@Valid UserUpdateVM model) {
        if (StringUtils.isBlank((CharSequence)model.getBirthDay())) {
            model.setBirthDay(null);
        }
        User user = (User)this.userService.selectById(this.getCurrentUser().getId());
        modelMapper.map((Object)model, (Object)user);
        user.setModifyTime(new Date());
        this.userService.updateByIdFilter((Object)user);
        UserEventLog userEventLog = new UserEventLog(user.getId(), user.getUserName(), user.getRealName(), new Date());
        userEventLog.setContent(user.getUserName() + " \u66f4\u65b0\u4e86\u4e2a\u4eba\u8d44\u6599");
        this.eventPublisher.publishEvent((ApplicationEvent)new UserEvent(userEventLog));
        UserResponseVM userVm = UserResponseVM.from((User)user);
        return RestResponse.ok((Object)userVm);
    }

    @RequestMapping(value={"/log"}, method={RequestMethod.POST})
    public RestResponse<List<UserEventLogVM>> log() {
        User user = this.getCurrentUser();
        List userEventLogs = this.userEventLogService.getUserEventLogByUserId(user.getId());
        List userEventLogVMS = userEventLogs.stream().map(d -> {
            UserEventLogVM vm = (UserEventLogVM)modelMapper.map(d, UserEventLogVM.class);
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)d.getCreateTime()));
            return vm;
        }).collect(Collectors.toList());
        return RestResponse.ok(userEventLogVMS);
    }

    @RequestMapping(value={"/message/page"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<MessageResponseVM>> messagePageList(MessageRequestVM messageRequestVM) {
        messageRequestVM.setReceiveUserId(this.getCurrentUser().getId());
        PageInfo messageUserPageInfo = this.messageService.studentPage(messageRequestVM);
        List ids = messageUserPageInfo.getList().stream().map(d -> d.getMessageId()).collect(Collectors.toList());
        List messages = ids.size() != 0 ? this.messageService.selectMessageByIds(ids) : null;
        PageInfo page = PageInfoHelper.copyMap((PageInfo)messageUserPageInfo, e -> {
            MessageResponseVM vm = (MessageResponseVM)modelMapper.map(e, MessageResponseVM.class);
            messages.stream().filter(d -> e.getMessageId().equals(d.getId())).findFirst().ifPresent(message -> {
                vm.setTitle(message.getTitle());
                vm.setContent(message.getContent());
                vm.setSendUserName(message.getSendUserName());
            });
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)e.getCreateTime()));
            return vm;
        });
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/message/detail/{id}"}, method={RequestMethod.POST})
    public RestResponse messageDetail(@PathVariable Integer id) {
        Message message = this.messageService.messageDetail(id);
        return RestResponse.ok((Object)message);
    }

    @RequestMapping(value={"/message/unreadCount"}, method={RequestMethod.POST})
    public RestResponse unReadCount() {
        Integer count = this.messageService.unReadCount(this.getCurrentUser().getId());
        return RestResponse.ok((Object)count);
    }

    @RequestMapping(value={"/message/read/{id}"}, method={RequestMethod.POST})
    public RestResponse read(@PathVariable Integer id) {
        this.messageService.read(id);
        return RestResponse.ok();
    }
}

