/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.ExamPaper;
import com.mindskip.xzs.domain.Question;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.enums.ExamPaperTypeEnum;
import com.mindskip.xzs.domain.exam.ExamPaperQuestionItemObject;
import com.mindskip.xzs.domain.exam.ExamPaperTitleItemObject;
import com.mindskip.xzs.domain.other.KeyValue;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.ExamPaperMapper;
import com.mindskip.xzs.repository.QuestionMapper;
import com.mindskip.xzs.service.ExamPaperService;
import com.mindskip.xzs.service.QuestionService;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.service.enums.ActionEnum;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.utility.ModelMapperSingle;
import com.mindskip.xzs.viewmodel.admin.exam.ExamPaperEditRequestVM;
import com.mindskip.xzs.viewmodel.admin.exam.ExamPaperPageRequestVM;
import com.mindskip.xzs.viewmodel.admin.exam.ExamPaperTitleItemVM;
import com.mindskip.xzs.viewmodel.admin.question.QuestionEditRequestVM;
import com.mindskip.xzs.viewmodel.student.dashboard.PaperFilter;
import com.mindskip.xzs.viewmodel.student.dashboard.PaperInfo;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperPageVM;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExamPaperServiceImpl
extends BaseServiceImpl<ExamPaper>
implements ExamPaperService {
    protected static final ModelMapper modelMapper = ModelMapperSingle.Instance();
    private final ExamPaperMapper examPaperMapper;
    private final QuestionMapper questionMapper;
    private final TextContentService textContentService;
    private final QuestionService questionService;
    private final SubjectService subjectService;

    @Autowired
    public ExamPaperServiceImpl(ExamPaperMapper examPaperMapper, QuestionMapper questionMapper, TextContentService textContentService, QuestionService questionService, SubjectService subjectService) {
        super((BaseMapper)examPaperMapper);
        this.examPaperMapper = examPaperMapper;
        this.questionMapper = questionMapper;
        this.textContentService = textContentService;
        this.questionService = questionService;
        this.subjectService = subjectService;
    }

    public PageInfo<ExamPaper> page(ExamPaperPageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.examPaperMapper.page(requestVM));
    }

    public PageInfo<ExamPaper> taskExamPage(ExamPaperPageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.examPaperMapper.taskExamPage(requestVM));
    }

    public PageInfo<ExamPaper> studentPage(ExamPaperPageVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.examPaperMapper.studentPage(requestVM));
    }

    @Transactional
    public ExamPaper savePaperFromVM(ExamPaperEditRequestVM examPaperEditRequestVM, User user) {
        ExamPaper examPaper;
        ActionEnum actionEnum = examPaperEditRequestVM.getId() == null ? ActionEnum.ADD : ActionEnum.UPDATE;
        Date now = new Date();
        List titleItemsVM = examPaperEditRequestVM.getTitleItems();
        List frameTextContentList = this.frameTextContentFromVM(titleItemsVM);
        String frameTextContentStr = JsonUtil.toJsonStr((Object)frameTextContentList);
        if (actionEnum == ActionEnum.ADD) {
            examPaper = (ExamPaper)modelMapper.map((Object)examPaperEditRequestVM, ExamPaper.class);
            TextContent frameTextContent = new TextContent(frameTextContentStr, now);
            this.textContentService.insertByFilter((Object)frameTextContent);
            examPaper.setFrameTextContentId(frameTextContent.getId());
            examPaper.setCreateTime(now);
            examPaper.setCreateUser(user.getId());
            examPaper.setDeleted(Boolean.valueOf(false));
            this.examPaperFromVM(examPaperEditRequestVM, examPaper, titleItemsVM);
            this.examPaperMapper.insertSelective((Object)examPaper);
        } else {
            examPaper = (ExamPaper)this.examPaperMapper.selectByPrimaryKey(examPaperEditRequestVM.getId());
            TextContent frameTextContent = (TextContent)this.textContentService.selectById(examPaper.getFrameTextContentId());
            frameTextContent.setContent(frameTextContentStr);
            this.textContentService.updateByIdFilter((Object)frameTextContent);
            modelMapper.map((Object)examPaperEditRequestVM, (Object)examPaper);
            this.examPaperFromVM(examPaperEditRequestVM, examPaper, titleItemsVM);
            this.examPaperMapper.updateByPrimaryKeySelective((Object)examPaper);
        }
        return examPaper;
    }

    public ExamPaperEditRequestVM examPaperToVM(Integer id) {
        ExamPaper examPaper = (ExamPaper)this.examPaperMapper.selectByPrimaryKey(id);
        ExamPaperEditRequestVM vm = (ExamPaperEditRequestVM)modelMapper.map((Object)examPaper, ExamPaperEditRequestVM.class);
        vm.setLevel(examPaper.getGradeLevel());
        TextContent frameTextContent = (TextContent)this.textContentService.selectById(examPaper.getFrameTextContentId());
        List examPaperTitleItemObjects = JsonUtil.toJsonListObject((String)frameTextContent.getContent(), ExamPaperTitleItemObject.class);
        List questionIds = examPaperTitleItemObjects.stream().flatMap(t -> t.getQuestionItems().stream().map(q -> q.getId())).collect(Collectors.toList());
        List questions = this.questionMapper.selectByIds(questionIds);
        List examPaperTitleItemVMS = examPaperTitleItemObjects.stream().map(t -> {
            ExamPaperTitleItemVM tTitleVM = (ExamPaperTitleItemVM)modelMapper.map(t, ExamPaperTitleItemVM.class);
            List questionItemsVM = t.getQuestionItems().stream().map(i -> {
                Question question = questions.stream().filter(q -> q.getId().equals(i.getId())).findFirst().get();
                QuestionEditRequestVM questionEditRequestVM = this.questionService.getQuestionEditRequestVM(question);
                questionEditRequestVM.setItemOrder(i.getItemOrder());
                return questionEditRequestVM;
            }).collect(Collectors.toList());
            tTitleVM.setQuestionItems(questionItemsVM);
            return tTitleVM;
        }).collect(Collectors.toList());
        vm.setTitleItems(examPaperTitleItemVMS);
        vm.setScore(ExamUtil.scoreToVM((Integer)examPaper.getScore()));
        if (ExamPaperTypeEnum.TimeLimit == ExamPaperTypeEnum.fromCode((Integer)examPaper.getPaperType())) {
            List<String> limitDateTime = Arrays.asList(DateTimeUtil.dateFormat((Date)examPaper.getLimitStartTime()), DateTimeUtil.dateFormat((Date)examPaper.getLimitEndTime()));
            vm.setLimitDateTime(limitDateTime);
        }
        return vm;
    }

    public List<PaperInfo> indexPaper(PaperFilter paperFilter) {
        return this.examPaperMapper.indexPaper(paperFilter);
    }

    public Integer selectAllCount() {
        return this.examPaperMapper.selectAllCount();
    }

    public List<Integer> selectMothCount() {
        Date startTime = DateTimeUtil.getMonthStartDay();
        Date endTime = DateTimeUtil.getMonthEndDay();
        List mouthCount = this.examPaperMapper.selectCountByDate(startTime, endTime);
        List mothStartToNowFormat = DateTimeUtil.MothStartToNowFormat();
        return mothStartToNowFormat.stream().map(md -> {
            KeyValue keyValue = mouthCount.stream().filter(kv -> kv.getName().equals(md)).findAny().orElse(null);
            return null == keyValue ? 0 : keyValue.getValue();
        }).collect(Collectors.toList());
    }

    private void examPaperFromVM(ExamPaperEditRequestVM examPaperEditRequestVM, ExamPaper examPaper, List<ExamPaperTitleItemVM> titleItemsVM) {
        Integer gradeLevel = this.subjectService.levelBySubjectId(examPaperEditRequestVM.getSubjectId());
        Integer questionCount = titleItemsVM.stream().mapToInt(t -> t.getQuestionItems().size()).sum();
        Integer score = titleItemsVM.stream().flatMapToInt(t -> t.getQuestionItems().stream().mapToInt(q -> ExamUtil.scoreFromVM((String)q.getScore()))).sum();
        examPaper.setQuestionCount(questionCount);
        examPaper.setScore(score);
        examPaper.setGradeLevel(gradeLevel);
        List dateTimes = examPaperEditRequestVM.getLimitDateTime();
        if (ExamPaperTypeEnum.TimeLimit == ExamPaperTypeEnum.fromCode((Integer)examPaper.getPaperType())) {
            examPaper.setLimitStartTime(DateTimeUtil.parse((String)((String)dateTimes.get(0)), (String)"yyyy-MM-dd HH:mm:ss"));
            examPaper.setLimitEndTime(DateTimeUtil.parse((String)((String)dateTimes.get(1)), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private List<ExamPaperTitleItemObject> frameTextContentFromVM(List<ExamPaperTitleItemVM> titleItems) {
        AtomicInteger index = new AtomicInteger(1);
        return titleItems.stream().map(t -> {
            ExamPaperTitleItemObject titleItem = (ExamPaperTitleItemObject)modelMapper.map(t, ExamPaperTitleItemObject.class);
            List questionItems = t.getQuestionItems().stream().map(q -> {
                ExamPaperQuestionItemObject examPaperQuestionItemObject = (ExamPaperQuestionItemObject)modelMapper.map(q, ExamPaperQuestionItemObject.class);
                examPaperQuestionItemObject.setItemOrder(Integer.valueOf(index.getAndIncrement()));
                return examPaperQuestionItemObject;
            }).collect(Collectors.toList());
            titleItem.setQuestionItems(questionItems);
            return titleItem;
        }).collect(Collectors.toList());
    }
}

