/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.Question;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.enums.QuestionStatusEnum;
import com.mindskip.xzs.domain.enums.QuestionTypeEnum;
import com.mindskip.xzs.domain.other.KeyValue;
import com.mindskip.xzs.domain.question.QuestionItemObject;
import com.mindskip.xzs.domain.question.QuestionObject;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.QuestionMapper;
import com.mindskip.xzs.service.QuestionService;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.service.impl.QuestionServiceImpl;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.utility.ModelMapperSingle;
import com.mindskip.xzs.viewmodel.admin.question.QuestionEditItemVM;
import com.mindskip.xzs.viewmodel.admin.question.QuestionEditRequestVM;
import com.mindskip.xzs.viewmodel.admin.question.QuestionPageRequestVM;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuestionServiceImpl
extends BaseServiceImpl<Question>
implements QuestionService {
    protected static final ModelMapper modelMapper = ModelMapperSingle.Instance();
    private final QuestionMapper questionMapper;
    private final TextContentService textContentService;
    private final SubjectService subjectService;

    @Autowired
    public QuestionServiceImpl(QuestionMapper questionMapper, TextContentService textContentService, SubjectService subjectService) {
        super((BaseMapper)questionMapper);
        this.textContentService = textContentService;
        this.questionMapper = questionMapper;
        this.subjectService = subjectService;
    }

    public PageInfo<Question> page(QuestionPageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.questionMapper.page(requestVM));
    }

    @Transactional
    public Question insertFullQuestion(QuestionEditRequestVM model, Integer userId) {
        Date now = new Date();
        Integer gradeLevel = this.subjectService.levelBySubjectId(model.getSubjectId());
        TextContent infoTextContent = new TextContent();
        infoTextContent.setCreateTime(now);
        this.setQuestionInfoFromVM(infoTextContent, model);
        this.textContentService.insertByFilter((Object)infoTextContent);
        Question question = new Question();
        question.setSubjectId(model.getSubjectId());
        question.setGradeLevel(gradeLevel);
        question.setCreateTime(now);
        question.setQuestionType(model.getQuestionType());
        question.setStatus(Integer.valueOf(QuestionStatusEnum.OK.getCode()));
        question.setCorrectFromVM(model.getCorrect(), model.getCorrectArray());
        question.setScore(ExamUtil.scoreFromVM((String)model.getScore()));
        question.setDifficult(model.getDifficult());
        question.setInfoTextContentId(infoTextContent.getId());
        question.setCreateUser(userId);
        question.setDeleted(Boolean.valueOf(false));
        this.questionMapper.insertSelective((Object)question);
        return question;
    }

    @Transactional
    public Question updateFullQuestion(QuestionEditRequestVM model) {
        Integer gradeLevel = this.subjectService.levelBySubjectId(model.getSubjectId());
        Question question = (Question)this.questionMapper.selectByPrimaryKey(model.getId());
        question.setSubjectId(model.getSubjectId());
        question.setGradeLevel(gradeLevel);
        question.setScore(ExamUtil.scoreFromVM((String)model.getScore()));
        question.setDifficult(model.getDifficult());
        question.setCorrectFromVM(model.getCorrect(), model.getCorrectArray());
        this.questionMapper.updateByPrimaryKeySelective((Object)question);
        TextContent infoTextContent = (TextContent)this.textContentService.selectById(question.getInfoTextContentId());
        this.setQuestionInfoFromVM(infoTextContent, model);
        this.textContentService.updateByIdFilter((Object)infoTextContent);
        return question;
    }

    public QuestionEditRequestVM getQuestionEditRequestVM(Integer questionId) {
        Question question = (Question)this.questionMapper.selectByPrimaryKey(questionId);
        return this.getQuestionEditRequestVM(question);
    }

    public QuestionEditRequestVM getQuestionEditRequestVM(Question question) {
        TextContent questionInfoTextContent = (TextContent)this.textContentService.selectById(question.getInfoTextContentId());
        QuestionObject questionObject = (QuestionObject)JsonUtil.toJsonObject((String)questionInfoTextContent.getContent(), QuestionObject.class);
        QuestionEditRequestVM questionEditRequestVM = (QuestionEditRequestVM)modelMapper.map((Object)question, QuestionEditRequestVM.class);
        questionEditRequestVM.setTitle(questionObject.getTitleContent());
        QuestionTypeEnum questionTypeEnum = QuestionTypeEnum.fromCode((Integer)question.getQuestionType());
        switch (1.$SwitchMap$com$mindskip$xzs$domain$enums$QuestionTypeEnum[questionTypeEnum.ordinal()]) {
            case 1: 
            case 2: {
                questionEditRequestVM.setCorrect(question.getCorrect());
                break;
            }
            case 3: {
                questionEditRequestVM.setCorrectArray(ExamUtil.contentToArray((String)question.getCorrect()));
                break;
            }
            case 4: {
                List correctContent = questionObject.getQuestionItemObjects().stream().map(d -> d.getContent()).collect(Collectors.toList());
                questionEditRequestVM.setCorrectArray(correctContent);
                break;
            }
            case 5: {
                questionEditRequestVM.setCorrect(questionObject.getCorrect());
                break;
            }
        }
        questionEditRequestVM.setScore(ExamUtil.scoreToVM((Integer)question.getScore()));
        questionEditRequestVM.setAnalyze(questionObject.getAnalyze());
        List editItems = questionObject.getQuestionItemObjects().stream().map(o -> {
            QuestionEditItemVM questionEditItemVM = (QuestionEditItemVM)modelMapper.map(o, QuestionEditItemVM.class);
            if (o.getScore() != null) {
                questionEditItemVM.setScore(ExamUtil.scoreToVM((Integer)o.getScore()));
            }
            return questionEditItemVM;
        }).collect(Collectors.toList());
        questionEditRequestVM.setItems(editItems);
        return questionEditRequestVM;
    }

    public void setQuestionInfoFromVM(TextContent infoTextContent, QuestionEditRequestVM model) {
        List itemObjects = model.getItems().stream().map(i -> {
            QuestionItemObject item = new QuestionItemObject();
            item.setPrefix(i.getPrefix());
            item.setContent(i.getContent());
            item.setItemUuid(i.getItemUuid());
            item.setScore(ExamUtil.scoreFromVM((String)i.getScore()));
            return item;
        }).collect(Collectors.toList());
        QuestionObject questionObject = new QuestionObject();
        questionObject.setQuestionItemObjects(itemObjects);
        questionObject.setAnalyze(model.getAnalyze());
        questionObject.setTitleContent(model.getTitle());
        questionObject.setCorrect(model.getCorrect());
        infoTextContent.setContent(JsonUtil.toJsonStr((Object)questionObject));
    }

    public Integer selectAllCount() {
        return this.questionMapper.selectAllCount();
    }

    public List<Integer> selectMothCount() {
        Date startTime = DateTimeUtil.getMonthStartDay();
        Date endTime = DateTimeUtil.getMonthEndDay();
        List mothStartToNowFormat = DateTimeUtil.MothStartToNowFormat();
        List mouthCount = this.questionMapper.selectCountByDate(startTime, endTime);
        return mothStartToNowFormat.stream().map(md -> {
            KeyValue keyValue = mouthCount.stream().filter(kv -> kv.getName().equals(md)).findAny().orElse(null);
            return null == keyValue ? 0 : keyValue.getValue();
        }).collect(Collectors.toList());
    }
}

