/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.mindskip.xzs.domain.ExamPaper;
import com.mindskip.xzs.domain.ExamPaperAnswer;
import com.mindskip.xzs.domain.TaskExamCustomerAnswer;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.task.TaskItemAnswerObject;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.TaskExamCustomerAnswerMapper;
import com.mindskip.xzs.service.TaskExamCustomerAnswerService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.utility.JsonUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskExamCustomerAnswerImpl
extends BaseServiceImpl<TaskExamCustomerAnswer>
implements TaskExamCustomerAnswerService {
    private final TaskExamCustomerAnswerMapper taskExamCustomerAnswerMapper;
    private final TextContentService textContentService;

    @Autowired
    public TaskExamCustomerAnswerImpl(TaskExamCustomerAnswerMapper taskExamCustomerAnswerMapper, TextContentService textContentService) {
        super((BaseMapper)taskExamCustomerAnswerMapper);
        this.taskExamCustomerAnswerMapper = taskExamCustomerAnswerMapper;
        this.textContentService = textContentService;
    }

    public void insertOrUpdate(ExamPaper examPaper, ExamPaperAnswer examPaperAnswer, Date now) {
        Integer userId;
        Integer taskId = examPaper.getTaskExamId();
        TaskExamCustomerAnswer taskExamCustomerAnswer = this.taskExamCustomerAnswerMapper.getByTUid(taskId, userId = examPaperAnswer.getCreateUser());
        if (null == taskExamCustomerAnswer) {
            taskExamCustomerAnswer = new TaskExamCustomerAnswer();
            taskExamCustomerAnswer.setCreateTime(now);
            taskExamCustomerAnswer.setCreateUser(userId);
            taskExamCustomerAnswer.setTaskExamId(taskId);
            List<TaskItemAnswerObject> taskItemAnswerObjects = Arrays.asList(new TaskItemAnswerObject(examPaperAnswer.getExamPaperId(), examPaperAnswer.getId(), examPaperAnswer.getStatus()));
            TextContent textContent = this.textContentService.jsonConvertInsert(taskItemAnswerObjects, now, null);
            this.textContentService.insertByFilter((Object)textContent);
            taskExamCustomerAnswer.setTextContentId(textContent.getId());
            this.insertByFilter((Object)taskExamCustomerAnswer);
        } else {
            TextContent textContent = (TextContent)this.textContentService.selectById(taskExamCustomerAnswer.getTextContentId());
            List taskItemAnswerObjects = JsonUtil.toJsonListObject((String)textContent.getContent(), TaskItemAnswerObject.class);
            taskItemAnswerObjects.add(new TaskItemAnswerObject(examPaperAnswer.getExamPaperId(), examPaperAnswer.getId(), examPaperAnswer.getStatus()));
            this.textContentService.jsonConvertUpdate(textContent, taskItemAnswerObjects, null);
            this.textContentService.updateByIdFilter((Object)textContent);
        }
    }

    public TaskExamCustomerAnswer selectByTUid(Integer tid, Integer uid) {
        return this.taskExamCustomerAnswerMapper.getByTUid(tid, uid);
    }

    public List<TaskExamCustomerAnswer> selectByTUid(List<Integer> taskIds, Integer uid) {
        return this.taskExamCustomerAnswerMapper.selectByTUid(taskIds, uid);
    }
}

