/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.ExamPaper;
import com.mindskip.xzs.domain.TaskExam;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.task.TaskItemObject;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.ExamPaperMapper;
import com.mindskip.xzs.repository.TaskExamMapper;
import com.mindskip.xzs.service.TaskExamService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.service.enums.ActionEnum;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.utility.ModelMapperSingle;
import com.mindskip.xzs.viewmodel.admin.exam.ExamResponseVM;
import com.mindskip.xzs.viewmodel.admin.task.TaskPageRequestVM;
import com.mindskip.xzs.viewmodel.admin.task.TaskRequestVM;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskExamServiceImpl
extends BaseServiceImpl<TaskExam>
implements TaskExamService {
    protected static final ModelMapper modelMapper = ModelMapperSingle.Instance();
    private final TaskExamMapper taskExamMapper;
    private final TextContentService textContentService;
    private final ExamPaperMapper examPaperMapper;

    @Autowired
    public TaskExamServiceImpl(TaskExamMapper taskExamMapper, TextContentService textContentService, ExamPaperMapper examPaperMapper) {
        super((BaseMapper)taskExamMapper);
        this.taskExamMapper = taskExamMapper;
        this.textContentService = textContentService;
        this.examPaperMapper = examPaperMapper;
    }

    public PageInfo<TaskExam> page(TaskPageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.taskExamMapper.page(requestVM));
    }

    @Transactional
    public void edit(TaskRequestVM model, User user) {
        ActionEnum actionEnum = model.getId() == null ? ActionEnum.ADD : ActionEnum.UPDATE;
        TaskExam taskExam = null;
        if (actionEnum == ActionEnum.ADD) {
            Date now = new Date();
            taskExam = (TaskExam)modelMapper.map((Object)model, TaskExam.class);
            taskExam.setCreateUser(user.getId());
            taskExam.setCreateUserName(user.getUserName());
            taskExam.setCreateTime(now);
            taskExam.setDeleted(Boolean.valueOf(false));
            TextContent textContent = this.textContentService.jsonConvertInsert(model.getPaperItems(), now, p -> {
                TaskItemObject taskItemObject = new TaskItemObject();
                taskItemObject.setExamPaperId(p.getId());
                taskItemObject.setExamPaperName(p.getName());
                return taskItemObject;
            });
            this.textContentService.insertByFilter((Object)textContent);
            taskExam.setFrameTextContentId(textContent.getId());
            this.taskExamMapper.insertSelective((Object)taskExam);
        } else {
            taskExam = (TaskExam)this.taskExamMapper.selectByPrimaryKey(model.getId());
            modelMapper.map((Object)model, (Object)taskExam);
            TextContent textContent = (TextContent)this.textContentService.selectById(taskExam.getFrameTextContentId());
            List paperIds = JsonUtil.toJsonListObject((String)textContent.getContent(), TaskItemObject.class).stream().map(d -> d.getExamPaperId()).collect(Collectors.toList());
            this.examPaperMapper.clearTaskPaper(paperIds);
            this.textContentService.jsonConvertUpdate(textContent, model.getPaperItems(), p -> {
                TaskItemObject taskItemObject = new TaskItemObject();
                taskItemObject.setExamPaperId(p.getId());
                taskItemObject.setExamPaperName(p.getName());
                return taskItemObject;
            });
            this.textContentService.updateByIdFilter((Object)textContent);
            this.taskExamMapper.updateByPrimaryKeySelective((Object)taskExam);
        }
        List paperIds = model.getPaperItems().stream().map(d -> d.getId()).collect(Collectors.toList());
        this.examPaperMapper.updateTaskPaper(taskExam.getId(), paperIds);
        model.setId(taskExam.getId());
    }

    public TaskRequestVM taskExamToVM(Integer id) {
        TaskExam taskExam = (TaskExam)this.taskExamMapper.selectByPrimaryKey(id);
        TaskRequestVM vm = (TaskRequestVM)modelMapper.map((Object)taskExam, TaskRequestVM.class);
        TextContent textContent = (TextContent)this.textContentService.selectById(taskExam.getFrameTextContentId());
        List examResponseVMS = JsonUtil.toJsonListObject((String)textContent.getContent(), TaskItemObject.class).stream().map(tk -> {
            ExamPaper examPaper = (ExamPaper)this.examPaperMapper.selectByPrimaryKey(tk.getExamPaperId());
            ExamResponseVM examResponseVM = (ExamResponseVM)modelMapper.map((Object)examPaper, ExamResponseVM.class);
            examResponseVM.setCreateTime(DateTimeUtil.dateFormat((Date)examPaper.getCreateTime()));
            return examResponseVM;
        }).collect(Collectors.toList());
        vm.setPaperItems(examResponseVMS);
        return vm;
    }

    public List<TaskExam> getByGradeLevel(Integer gradeLevel) {
        return this.taskExamMapper.getByGradeLevel(gradeLevel);
    }
}

