/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.UserEventLog;
import com.mindskip.xzs.domain.other.KeyValue;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.UserEventLogMapper;
import com.mindskip.xzs.service.UserEventLogService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.viewmodel.admin.user.UserEventPageRequestVM;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserEventLogServiceImpl
extends BaseServiceImpl<UserEventLog>
implements UserEventLogService {
    private final UserEventLogMapper userEventLogMapper;

    @Autowired
    public UserEventLogServiceImpl(UserEventLogMapper userEventLogMapper) {
        super((BaseMapper)userEventLogMapper);
        this.userEventLogMapper = userEventLogMapper;
    }

    public List<UserEventLog> getUserEventLogByUserId(Integer id) {
        return this.userEventLogMapper.getUserEventLogByUserId(id);
    }

    public PageInfo<UserEventLog> page(UserEventPageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.userEventLogMapper.page(requestVM));
    }

    public List<Integer> selectMothCount() {
        Date startTime = DateTimeUtil.getMonthStartDay();
        Date endTime = DateTimeUtil.getMonthEndDay();
        List mouthCount = this.userEventLogMapper.selectCountByDate(startTime, endTime);
        List mothStartToNowFormat = DateTimeUtil.MothStartToNowFormat();
        return mothStartToNowFormat.stream().map(md -> {
            KeyValue keyValue = mouthCount.stream().filter(kv -> kv.getName().equals(md)).findAny().orElse(null);
            return null == keyValue ? 0 : keyValue.getValue();
        }).collect(Collectors.toList());
    }
}

