/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.mindskip.xzs.configuration.property.SystemConfig;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.UserToken;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.UserTokenMapper;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.service.UserTokenService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.utility.DateTimeUtil;
import java.time.Duration;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserTokenServiceImpl
extends BaseServiceImpl<UserToken>
implements UserTokenService {
    private final UserTokenMapper userTokenMapper;
    private final UserService userService;
    private final SystemConfig systemConfig;

    @Autowired
    public UserTokenServiceImpl(UserTokenMapper userTokenMapper, UserService userService, SystemConfig systemConfig) {
        super((BaseMapper)userTokenMapper);
        this.userTokenMapper = userTokenMapper;
        this.userService = userService;
        this.systemConfig = systemConfig;
    }

    @Transactional
    public UserToken bind(User user) {
        user.setModifyTime(new Date());
        this.userService.updateByIdFilter((Object)user);
        return this.insertUserToken(user);
    }

    public UserToken checkBind(String openId) {
        User user = this.userService.selectByWxOpenId(openId);
        if (null != user) {
            return this.insertUserToken(user);
        }
        return null;
    }

    public UserToken getToken(String token) {
        return this.userTokenMapper.getToken(token);
    }

    public UserToken insertUserToken(User user) {
        Date startTime = new Date();
        Date endTime = DateTimeUtil.addDuration((Date)startTime, (Duration)this.systemConfig.getWx().getTokenToLive());
        UserToken userToken = new UserToken();
        userToken.setToken(UUID.randomUUID().toString());
        userToken.setUserId(user.getId());
        userToken.setWxOpenId(user.getWxOpenId());
        userToken.setCreateTime(startTime);
        userToken.setEndTime(endTime);
        userToken.setUserName(user.getUserName());
        this.userService.updateByIdFilter((Object)user);
        this.userTokenMapper.insertSelective((Object)userToken);
        return userToken;
    }

    public void unBind(UserToken userToken) {
        User user = (User)this.userService.selectById(userToken.getUserId());
        user.setModifyTime(new Date());
        user.setWxOpenId(null);
        this.userService.updateById((Object)user);
        this.userTokenMapper.deleteByPrimaryKey(userToken.getId());
    }
}

