/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.utility;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ExamUtil {
    private static final String ANSWER_SPLIT = ",";
    private static final String FORM_ANSWER_SPLIT = "_";

    public static String scoreToVM(Integer score) {
        if (score % 10 == 0) {
            return String.valueOf(score / 10);
        }
        return String.format("%.1f", (double)score.intValue() / 10.0);
    }

    public static Integer scoreFromVM(String score) {
        if (score == null) {
            return null;
        }
        return (int)(Float.parseFloat(score) * 10.0f);
    }

    public static String secondToVM(Integer second) {
        long days = second / 86400;
        long hours = second % 86400 / 3600;
        long minutes = second % 3600 / 60;
        long seconds = second % 60;
        String dateTimes = days > 0L ? days + "\u5929 " + hours + "\u65f6 " + minutes + "\u5206 " + seconds + "\u79d2" : (hours > 0L ? hours + "\u65f6 " + minutes + "\u5206 " + seconds + "\u79d2" : (minutes > 0L ? minutes + "\u5206 " + seconds + "\u79d2" : seconds + " \u79d2"));
        return dateTimes;
    }

    public static String contentToString(List<String> contentArray) {
        return contentArray.stream().sorted().collect(Collectors.joining(ANSWER_SPLIT));
    }

    public static List<String> contentToArray(String contentArray) {
        return Arrays.asList(contentArray.split(ANSWER_SPLIT));
    }

    public static Integer lastNum(String str) {
        Integer start = str.lastIndexOf(FORM_ANSWER_SPLIT);
        return Integer.parseInt(str.substring(start + 1));
    }
}

