# 项目名称：企业微信机器人自动推送某主题文章

## 使用说明：根据下方步骤部署即可

### **（1）首先修改/robotv1中的内容，实现推送文章的功能**

1. **本项目推送的文章是关于职场新人的，如果您不需要修改主题直接用，那么可以进入第2步**

2. **`/robotv1/pkg/article/deepseek_generator.go`修改推送文章的类型，将40-48行的两个`content（System Prompt和User Prompt）`修改成你需要给ai设定的身份，再将`/robotv1/articles/template.md`修改成你想要的排版格式** 

3. **`/robotv1/config/config.yaml`填写企业微信机器人api地址和deepseekapi地址（如果使用其他大模型需要自己摸索）**

4. **`/robotv1/pkg/wechat/robot.go` 设置展示在企业微信群的形式，我这里用的是卡片形式，对应三个位置三个链接，第一个链接就是我们项目目录中的a.php，第二个链接是web服务器目录的文件地址，第三个链接是外部页面（本人的其他网站页面链接充数）**

<img src="D:\Alinuxproject\robotv1\企业微信群内展示效果.jpg" alt="企业微信群内展示效果" style="zoom: 33%;" /><img src="D:\Alinuxproject\robotv1\a.php展示.png" alt="image-20250913185224755" style="zoom: 50%;" />



### (2) 程序可以成功推送文章之后将项目部署到服务器

- **安装go1.23.10**
- **安装php,nginx,lsyncd,crond,nginx，版本随意**
- **目录结构如下图所示：**
- **![目录结构展示](D:\Alinuxproject\robotv1\目录结构展示.jpg)**
- **在项目根目录下运行go run main.go即可开始推送文章，成功后将项目编译为可执行文件，使用如下命令：**
- **go build -o robotv1 main.go**
- **设置每天定时推送需要使用crontab -e**
- **#每天上午9点**
- **00 9 * * * /robotv1/robotv1.sh**

- **nginx站点目录配置文件和lsyncd配置文件都在项目根目录下**
- **将robot.conf放在/etc/nginx/conf.d/下，配置**
- **将lsyncd.conf放在/etc下，启动lsyncd服务实时同步项目目录里的文章与网页目录里的文章**