/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.kit.PathKit;
import com.jfinal.upload.UploadFile;
import io.jpress.core.JBaseController;
import io.jpress.core.addon.AddonInfo;
import io.jpress.core.addon.AddonManager;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.menu.MenuManager;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.utils.StringUtils;
import java.io.File;

@RouterMapping(url="/admin/addon", viewPath="/WEB-INF/admin/addon")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _AddonController
extends JBaseController {
    public void index() {
        this.keepPara();
        this.setAttr("addons", (Object)AddonManager.me().getAddons());
        this.setAttr("addonCount", (Object)AddonManager.me().getAddons().size());
        this.setAttr("startedAddonCount", (Object)AddonManager.me().getStartedAddons().size());
    }

    public void install() {
        this.keepPara();
        if (!this.isMultipartRequest()) {
            return;
        }
        UploadFile ufile = this.getFile();
        if (ufile == null) {
            this.renderAjaxResultForError("\u60a8\u8fd8\u672a\u9009\u62e9\u63d2\u4ef6\u6587\u4ef6");
            return;
        }
        String webRoot = PathKit.getWebRootPath();
        StringBuilder newFileName = new StringBuilder(webRoot).append("/WEB-INF/addons/").append(ufile.getFileName());
        File newfile = new File(newFileName.toString());
        if (newfile.exists()) {
            this.renderAjaxResultForError("\u8be5\u63d2\u4ef6\u5df2\u7ecf\u5b89\u88c5\uff01");
            return;
        }
        if (!newfile.getParentFile().exists()) {
            newfile.getParentFile().mkdirs();
        }
        ufile.getFile().renameTo(newfile);
        if (AddonManager.me().install(newfile)) {
            MenuManager.me().refresh();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError("\u5b89\u88c5\u5931\u8d25\uff0c\u53ef\u80fd\u5df2\u7ecf\u6709\u76f8\u540cID\u7684\u63d2\u4ef6\u4e86\u3002");
        }
    }

    public void uninstall() {
        this.keepPara();
        String id = this.getPara("id");
        if (StringUtils.isBlank((String)id)) {
            this.renderAjaxResultForError();
            return;
        }
        AddonInfo addon = AddonManager.me().findById(id);
        if (addon == null) {
            this.renderAjaxResultForError();
            return;
        }
        if (AddonManager.me().uninstall(addon)) {
            MenuManager.me().refresh();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void start() {
        this.keepPara();
        String id = this.getPara("id");
        if (StringUtils.isBlank((String)id)) {
            this.renderAjaxResultForError();
            return;
        }
        AddonInfo addon = AddonManager.me().findById(id);
        if (addon == null) {
            this.renderAjaxResultForError();
            return;
        }
        if (AddonManager.me().start(addon)) {
            MenuManager.me().refresh();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void stop() {
        this.keepPara();
        String id = this.getPara("id");
        if (StringUtils.isBlank((String)id)) {
            this.renderAjaxResultForError();
            return;
        }
        AddonInfo addon = AddonManager.me().findById(id);
        if (addon == null) {
            this.renderAjaxResultForError();
            return;
        }
        if (AddonManager.me().stop(addon)) {
            MenuManager.me().refresh();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }
}

