/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.aop.Clear;
import com.jfinal.core.Controller;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.JBaseController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.interceptor.AdminInterceptor;
import io.jpress.interceptor.UCodeInterceptor;
import io.jpress.message.MessageKit;
import io.jpress.model.User;
import io.jpress.model.query.CommentQuery;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.UserQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.utils.CookieUtils;
import io.jpress.utils.EncryptUtils;
import io.jpress.utils.StringUtils;
import java.util.List;

@RouterMapping(url="/admin", viewPath="/WEB-INF/admin")
@RouterNotAllowConvert
public class _AdminController
extends JBaseController {
    @Before(value={ActionCacheClearInterceptor.class})
    public void index() {
        Page commentPage;
        List moduleList = TemplateManager.me().currentTemplateModules();
        this.setAttr("modules", (Object)moduleList);
        if (moduleList != null && moduleList.size() > 0) {
            String[] moduels = new String[moduleList.size()];
            for (int i = 0; i < moduleList.size(); ++i) {
                moduels[i] = ((TplModule)moduleList.get(i)).getName();
            }
            List contents = ContentQuery.me().findListInNormal(1, 20, null, null, null, null, moduels, null, null, null, null, null, null, null, null);
            this.setAttr("contents", (Object)contents);
        }
        if ((commentPage = CommentQuery.me().paginateWithContentNotInDelete(1, 10, null, null, null, null)) != null) {
            this.setAttr("comments", (Object)commentPage.getList());
        }
        this.render("index.html");
    }

    @Clear(value={AdminInterceptor.class})
    public void login() {
        String password;
        String username = this.getPara("username");
        if (!StringUtils.areNotEmpty((String[])new String[]{username, password = this.getPara("password")})) {
            this.render("login.html");
            return;
        }
        User user = UserQuery.me().findUserByUsername(username);
        if (null == user) {
            this.renderAjaxResultForError("\u6ca1\u6709\u8be5\u7528\u6237");
            return;
        }
        if (EncryptUtils.verlifyUser((String)user.getPassword(), (String)user.getSalt(), (String)password) && user.isAdministrator()) {
            MessageKit.sendMessage((String)"user:logined", (Object)user);
            CookieUtils.put((Controller)this, (String)"user", (String)user.getId().toString());
            this.renderAjaxResultForSuccess("\u767b\u9646\u6210\u529f");
        } else {
            this.renderAjaxResultForError("\u5bc6\u7801\u9519\u8bef");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void logout() {
        CookieUtils.remove((Controller)this, (String)"user");
        this.redirect("/admin");
    }
}

