/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.alibaba.fastjson.JSONObject;
import com.jfinal.aop.Before;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.upload.UploadFile;
import io.jpress.core.JBaseCRUDController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.model.Attachment;
import io.jpress.model.User;
import io.jpress.model.query.AttachmentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.template.Thumbnail;
import io.jpress.utils.AttachmentUtils;
import io.jpress.utils.FileUtils;
import io.jpress.utils.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

@RouterMapping(url="/admin/attachment", viewPath="/WEB-INF/admin/attachment")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _AttachmentController
extends JBaseCRUDController<Attachment> {
    private static final Log log = Log.getLog(_AttachmentController.class);

    public void index() {
        this.keepPara();
        Page page = AttachmentQuery.me().paginate(this.getPageNumber(), this.getPageSize(), null, null, null, null, this.getPara("k", "").trim(), this.getPara("dm"), this.getPara("mime"), null);
        this.setAttr("page", (Object)page);
        List archives = AttachmentQuery.me().findArchives();
        this.setAttr("archives", (Object)archives);
        this.render("index.html");
    }

    public void detail_layer() {
        BigInteger id = this.getParaToBigInteger("id");
        Attachment attachment = AttachmentQuery.me().findById(id);
        this.setAttr("attachment", (Object)attachment);
        File attachmentFile = new File(PathKit.getWebRootPath(), attachment.getPath());
        this.setAttr("attachmentName", (Object)attachmentFile.getName());
        long fileLen = attachmentFile.length();
        String fileLenUnit = "Byte";
        if (fileLen > 1024L) {
            fileLen /= 1024L;
            fileLenUnit = "KB";
        }
        if (fileLen > 1024L) {
            fileLen /= 1024L;
            fileLenUnit = "MB";
        }
        this.setAttr("attachmentSize", (Object)(fileLen + fileLenUnit));
        try {
            if (AttachmentUtils.isImage((String)attachment.getPath())) {
                String ratio = ImageUtils.ratioAsString((String)attachmentFile.getAbsolutePath());
                this.setAttr("attachmentRatio", (Object)(ratio == null ? "unknow" : ratio));
            }
        }
        catch (Throwable e) {
            log.error("detail_layer ratioAsString error", e);
        }
    }

    public void choose_layer() {
        this.keepPara();
        Page page = AttachmentQuery.me().paginate(this.getPageNumber(), this.getPageSize(), null, null, null, null, this.getPara("k", "").trim(), this.getPara("dm"), this.getPara("mime"), null);
        this.setAttr("page", (Object)page);
        this.render("choose_layer.html");
    }

    protected int getPageSize() {
        return 18;
    }

    public void upload() {
        this.keepPara();
    }

    public void doUpload() {
        UploadFile uploadFile = this.getFile();
        if (null != uploadFile) {
            String newPath = AttachmentUtils.moveFile((UploadFile)uploadFile);
            User user = this.getLoginedUser();
            Attachment attachment = new Attachment();
            attachment.setUserId(user.getId());
            attachment.setCreated(new Date());
            attachment.setTitle(uploadFile.getOriginalFileName());
            attachment.setPath(newPath.replace("\\", "/"));
            attachment.setSuffix(FileUtils.getSuffix((String)uploadFile.getFileName()));
            attachment.setMimeType(uploadFile.getContentType());
            attachment.save();
            this.processImage(newPath);
            JSONObject json = new JSONObject();
            json.put("success", (Object)true);
            json.put("src", (Object)(this.getRequest().getContextPath() + newPath));
            this.renderJson(json.toString());
        } else {
            this.renderJson("success", (Object)false);
        }
    }

    private void processImage(String newPath) {
        if (!AttachmentUtils.isImage((String)newPath)) {
            return;
        }
        if (".gif".equalsIgnoreCase(FileUtils.getSuffix((String)newPath))) {
            return;
        }
        try {
            this.processThumbnail(newPath);
        }
        catch (Throwable e) {
            log.error("processThumbnail error", e);
        }
        try {
            this.processWatermark(newPath);
        }
        catch (Throwable e) {
            log.error("processWatermark error", e);
        }
    }

    private void processThumbnail(String newPath) {
        List tbs = TemplateManager.me().currentTemplate().getThumbnails();
        if (tbs != null && tbs.size() > 0) {
            for (Thumbnail tb : tbs) {
                try {
                    String newSrc = ImageUtils.scale((String)(PathKit.getWebRootPath() + newPath), (int)tb.getWidth(), (int)tb.getHeight());
                    this.processWatermark(FileUtils.removeRootPath((String)newSrc));
                }
                catch (IOException e) {
                    log.error("processWatermark error", (Throwable)e);
                }
            }
        }
    }

    public void processWatermark(String newPath) {
        Boolean watermark_enable = OptionQuery.me().findValueAsBool("watermark_enable");
        if (watermark_enable != null && watermark_enable.booleanValue()) {
            int position = OptionQuery.me().findValueAsInteger("watermark_position");
            String watermarkImg = OptionQuery.me().findValue("watermark_image");
            String srcImageFile = newPath;
            Float transparency = OptionQuery.me().findValueAsFloat("watermark_transparency");
            if (transparency == null || transparency.floatValue() < 0.0f || transparency.floatValue() > 1.0f) {
                transparency = Float.valueOf(1.0f);
            }
            srcImageFile = PathKit.getWebRootPath() + srcImageFile;
            File watermarkFile = new File(PathKit.getWebRootPath(), watermarkImg);
            if (!watermarkFile.exists()) {
                return;
            }
            ImageUtils.pressImage((String)watermarkFile.getAbsolutePath(), (String)srcImageFile, (String)srcImageFile, (int)position, (float)transparency.floatValue());
        }
    }
}

