/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.JBaseCRUDController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.interceptor.UCodeInterceptor;
import io.jpress.message.MessageKit;
import io.jpress.model.Comment;
import io.jpress.model.Content;
import io.jpress.model.User;
import io.jpress.model.query.CommentQuery;
import io.jpress.model.query.UserQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.utils.JsoupUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Date;

@RouterMapping(url="/admin/comment", viewPath="/WEB-INF/admin/comment")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _CommentController
extends JBaseCRUDController<Comment> {
    private String getModule() {
        return this.getPara("m");
    }

    private String getType() {
        return this.getPara("t");
    }

    public void index() {
        this.keepPara();
        this.setAttr("module", (Object)TemplateManager.me().currentTemplateModule(this.getModule()));
        this.setAttr("delete_count", (Object)CommentQuery.me().findCountByModuleAndStatus(this.getModule(), Comment.STATUS_DELETE));
        this.setAttr("draft_count", (Object)CommentQuery.me().findCountByModuleAndStatus(this.getModule(), Comment.STATUS_DRAFT));
        this.setAttr("normal_count", (Object)CommentQuery.me().findCountByModuleAndStatus(this.getModule(), Comment.STATUS_NORMAL));
        this.setAttr("count", (Object)CommentQuery.me().findCountInNormalByModule(this.getModule()));
        super.index();
    }

    public Page<Comment> onIndexDataLoad(int pageNumber, int pageSize) {
        BigInteger contentId = this.getParaToBigInteger("cid");
        BigInteger parentCommentId = this.getParaToBigInteger("pid");
        if (StringUtils.isNotBlank((String)this.getPara("s"))) {
            return CommentQuery.me().paginateWithContent(pageNumber, pageSize, this.getModule(), this.getType(), contentId, parentCommentId, this.getPara("s"));
        }
        return CommentQuery.me().paginateWithContentNotInDelete(pageNumber, pageSize, this.getModule(), this.getType(), contentId, parentCommentId);
    }

    public void edit() {
        BigInteger id = this.getParaToBigInteger("id");
        Comment comment = CommentQuery.me().findById((Object)id);
        this.setAttr("comment", (Object)comment);
    }

    @Before(value={UCodeInterceptor.class})
    public void trash() {
        Comment c = CommentQuery.me().findById((Object)this.getParaToBigInteger("id"));
        if (c != null) {
            c.setStatus(Comment.STATUS_DELETE);
            if (c.saveOrUpdate()) {
                MessageKit.sendMessage((String)"comment:update", (Object)c);
                this.renderAjaxResultForSuccess();
            } else {
                this.renderAjaxResultForError("restore error!");
            }
        } else {
            this.renderAjaxResultForError("trash error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void restore() {
        BigInteger id = this.getParaToBigInteger("id");
        Comment c = CommentQuery.me().findById((Object)id);
        if (c != null && c.isDelete()) {
            c.setStatus(Content.STATUS_DRAFT);
            if (c.saveOrUpdate()) {
                MessageKit.sendMessage((String)"comment:update", (Object)c);
                this.renderAjaxResultForSuccess("success");
            } else {
                this.renderAjaxResultForError("restore error!");
            }
        } else {
            this.renderAjaxResultForError("restore error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void pub() {
        BigInteger id = this.getParaToBigInteger("id");
        Comment c = CommentQuery.me().findById((Object)id);
        if (c != null) {
            c.setStatus(Content.STATUS_NORMAL);
            if (c.saveOrUpdate()) {
                MessageKit.sendMessage((String)"comment:update", (Object)c);
                this.renderAjaxResultForSuccess("success");
            } else {
                this.renderAjaxResultForError("pub fail!");
            }
        } else {
            this.renderAjaxResultForError("pub error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void draft() {
        BigInteger id = this.getParaToBigInteger("id");
        Comment c = CommentQuery.me().findById((Object)id);
        if (c != null) {
            c.setStatus(Content.STATUS_DRAFT);
            if (c.saveOrUpdate()) {
                MessageKit.sendMessage((String)"comment:update", (Object)c);
                this.renderAjaxResultForSuccess("success");
            } else {
                this.renderAjaxResultForError("draft fail!");
            }
        } else {
            this.renderAjaxResultForError("draft error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void delete() {
        BigInteger id = this.getParaToBigInteger("id");
        Comment c = CommentQuery.me().findById((Object)id);
        if (c != null && c.delete()) {
            MessageKit.sendMessage((String)"comment:delete", (Object)c);
            this.renderAjaxResultForSuccess();
            return;
        }
        this.renderAjaxResultForError();
    }

    public void save() {
        Comment comment = (Comment)this.getModel(Comment.class);
        String username = this.getPara("username");
        if (StringUtils.isNotBlank((String)username)) {
            User user = UserQuery.me().findUserByUsername(username);
            if (user == null) {
                this.renderAjaxResultForError("\u7cfb\u7edf\u6ca1\u6709\u8be5\u7528\u6237\uff1a" + username);
                return;
            }
            comment.setUserId(user.getId());
        }
        if (comment.saveOrUpdate()) {
            comment.updateCommentCount();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void reply_layer() {
        BigInteger id = this.getParaToBigInteger("id");
        this.setAttr("comment", (Object)CommentQuery.me().findById((Object)id));
    }

    public void reply() {
        Comment comment = (Comment)this.getModel(Comment.class);
        comment.setType("comment");
        comment.setIp(this.getIPAddress());
        comment.setAgent(this.getUserAgent());
        User user = this.getLoginedUser();
        String author = StringUtils.isNotBlank((String)user.getNickname()) ? user.getNickname() : user.getUsername();
        comment.setAuthor(author);
        comment.setEmail(user.getEmail());
        comment.setStatus(Comment.STATUS_NORMAL);
        comment.setUserId(user.getId());
        comment.setCreated(new Date());
        comment.setText(JsoupUtils.getBodyHtml((String)comment.getText()));
        comment.save();
        this.renderAjaxResultForSuccess();
    }
}

