/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.JBaseCRUDController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.core.render.AjaxResult;
import io.jpress.interceptor.UCodeInterceptor;
import io.jpress.message.MessageKit;
import io.jpress.model.Content;
import io.jpress.model.Taxonomy;
import io.jpress.model.User;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.model.query.UserQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.router.converter.ContentRouter;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.template.TplTaxonomyType;
import io.jpress.utils.JsoupUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RouterMapping(url="/admin/content", viewPath="/WEB-INF/admin/content")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _ContentController
extends JBaseCRUDController<Content> {
    private String getModuleName() {
        return this.getPara("m");
    }

    private String getStatus() {
        return this.getPara("s");
    }

    public void index() {
        TplModule module = TemplateManager.me().currentTemplateModule(this.getModuleName());
        this.setAttr("module", (Object)module);
        this.setAttr("delete_count", (Object)ContentQuery.me().findCountByModuleAndStatus(this.getModuleName(), Content.STATUS_DELETE));
        this.setAttr("draft_count", (Object)ContentQuery.me().findCountByModuleAndStatus(this.getModuleName(), Content.STATUS_DRAFT));
        this.setAttr("normal_count", (Object)ContentQuery.me().findCountByModuleAndStatus(this.getModuleName(), Content.STATUS_NORMAL));
        this.setAttr("count", (Object)ContentQuery.me().findCountInNormalByModule(this.getModuleName()));
        this.setAttr("tids", (Object)this.getPara("tids"));
        BigInteger[] tids = null;
        String[] tidStrings = this.getPara("tids", "").split(",");
        ArrayList<BigInteger> tidList = new ArrayList<BigInteger>();
        for (String stringid : tidStrings) {
            if (!StringUtils.isNotBlank((String)stringid)) continue;
            tidList.add(new BigInteger(stringid));
        }
        tids = tidList.toArray(new BigInteger[0]);
        String keyword = this.getPara("k", "").trim();
        Page page = null;
        page = StringUtils.isNotBlank((String)this.getStatus()) ? ContentQuery.me().paginateBySearch(this.getPageNumber(), this.getPageSize(), this.getModuleName(), keyword, this.getStatus(), tids, null) : ContentQuery.me().paginateByModuleNotInDelete(this.getPageNumber(), this.getPageSize(), this.getModuleName(), keyword, tids, null);
        this.filterUI(tids);
        this.setAttr("page", (Object)page);
        String templateHtml = String.format("admin_content_index_%s.html", module.getName());
        for (int i = 0; i < 2; ++i) {
            if (TemplateManager.me().existsFile(templateHtml)) {
                this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
                return;
            }
            templateHtml = templateHtml.substring(0, templateHtml.lastIndexOf("_")) + ".html";
        }
        this.setAttr("include", (Object)"_index_include.html");
    }

    private void filterUI(BigInteger[] tids) {
        TplModule module = TemplateManager.me().currentTemplateModule(this.getModuleName());
        if (module == null) {
            return;
        }
        List types = module.getTaxonomyTypes();
        if (types != null && !types.isEmpty()) {
            HashMap<String, List> _taxonomyMap = new HashMap<String, List>();
            for (TplTaxonomyType type : types) {
                if (!"select".equals(type.getFormType())) continue;
                List taxonomys = TaxonomyQuery.me().findListByModuleAndTypeAsSort(this.getModuleName(), type.getName());
                this.processSelected(tids, taxonomys);
                _taxonomyMap.put(type.getTitle(), taxonomys);
            }
            this.setAttr("_taxonomyMap", _taxonomyMap);
        }
    }

    private void processSelected(BigInteger[] tids, List<Taxonomy> taxonomys) {
        if (taxonomys == null || taxonomys.isEmpty()) {
            return;
        }
        if (tids == null || tids.length == 0) {
            return;
        }
        for (Taxonomy t : taxonomys) {
            for (BigInteger id : tids) {
                if (t.getId().compareTo(id) != 0) continue;
                t.put("_selected", (Object)"selected=\"selected\"");
            }
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void trash() {
        Content c = ContentQuery.me().findById(this.getParaToBigInteger("id"));
        if (c != null) {
            c.setStatus(Content.STATUS_DELETE);
            c.saveOrUpdate();
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("trash error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void draft() {
        Content c = ContentQuery.me().findById(this.getParaToBigInteger("id"));
        if (c != null) {
            c.setStatus(Content.STATUS_DRAFT);
            c.saveOrUpdate();
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("trash error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void batchTrash() {
        BigInteger[] ids = this.getParaValuesToBigInteger("dataItem");
        int count = ContentQuery.me().batchTrash(ids);
        if (count > 0) {
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("trash error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void batchDelete() {
        BigInteger[] ids = this.getParaValuesToBigInteger("dataItem");
        int count = ContentQuery.me().batchDelete(ids);
        if (count > 0) {
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("trash error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void restore() {
        BigInteger id = this.getParaToBigInteger("id");
        Content c = ContentQuery.me().findById(id);
        if (c != null && c.isDelete()) {
            c.setStatus(Content.STATUS_DRAFT);
            c.setModified(new Date());
            c.saveOrUpdate();
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("restore error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void delete() {
        BigInteger id = this.getParaToBigInteger("id");
        Content c = ContentQuery.me().findById(id);
        if (c == null) {
            this.renderAjaxResultForError();
            return;
        }
        boolean isSuccess = Db.tx((IAtom)new /* Unavailable Anonymous Inner Class!! */);
        if (isSuccess) {
            this.renderAjaxResultForSuccess();
            return;
        }
        this.renderAjaxResultForError();
    }

    public void edit() {
        String moduleName = this.getModuleName();
        BigInteger contentId = this.getParaToBigInteger("id");
        Content content = ContentQuery.me().findById(contentId);
        if (content != null) {
            this.setAttr("content", (Object)content);
            moduleName = content.getModule();
        }
        TplModule module = TemplateManager.me().currentTemplateModule(moduleName);
        this.setAttr("module", (Object)module);
        String _editor = this.getCookie("_editor", "tinymce");
        this.setAttr("_editor", (Object)_editor);
        this.setAttr("urlPreffix", (Object)ContentRouter.getContentRouterPreffix((TplModule)module));
        this.setAttr("urlSuffix", (Object)ContentRouter.getContentRouterSuffix((TplModule)module));
        this.setSlugInputDisplay(moduleName);
        String templateHtml = String.format("admin_content_edit_%s.html", moduleName);
        for (int i = 0; i < 2; ++i) {
            if (TemplateManager.me().existsFile(templateHtml)) {
                this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
                return;
            }
            templateHtml = templateHtml.substring(0, templateHtml.lastIndexOf("_")) + ".html";
        }
        this.setAttr("include", (Object)"_edit_include.html");
    }

    private void setSlugInputDisplay(String moduleName) {
        if ("page".equals(moduleName)) {
            this.setAttr("slugDisplay", (Object)"true");
            return;
        }
        String routerType = ContentRouter.getRouterType();
        if (StringUtils.isBlank((String)routerType)) {
            return;
        }
        if ("_dynamic_id".equals(routerType) || "_static_module_id".equals(routerType) || "_static_date_id".equals(routerType) || "_static_prefix_id".equals(routerType)) {
            return;
        }
        this.setAttr("slugDisplay", (Object)"true");
    }

    public void changeEditor() {
        String name = this.getPara();
        this.setCookie("_editor", name, Integer.MAX_VALUE);
        this.renderAjaxResultForSuccess();
    }

    public List<BigInteger> getOrCreateTaxonomyIds(String moduleName) {
        TplModule module = TemplateManager.me().currentTemplateModule(moduleName);
        List types = module.getTaxonomyTypes();
        ArrayList<BigInteger> tIds = new ArrayList<BigInteger>();
        for (TplTaxonomyType type : types) {
            BigInteger[] ids;
            if (type.isInputType()) {
                String[] slugs;
                String slugsData = this.getPara("_" + type.getName());
                if (StringUtils.isBlank((String)slugsData)) continue;
                List taxonomyList = TaxonomyQuery.me().findListByModuleAndType(moduleName, type.getName());
                for (String slug : slugs = slugsData.split(",")) {
                    BigInteger id = this.getTaxonomyIdFromListBySlug(slug, taxonomyList);
                    if (id == null) {
                        Taxonomy taxonomy = new Taxonomy();
                        taxonomy.setTitle(slug);
                        taxonomy.setSlug(slug);
                        taxonomy.setContentModule(moduleName);
                        taxonomy.setType(type.getName());
                        if (taxonomy.save()) {
                            id = taxonomy.getId();
                        }
                    }
                    tIds.add(id);
                }
                continue;
            }
            if (!type.isSelectType() || (ids = this.getParaValuesToBigInteger("_" + type.getName())) == null || ids.length <= 0) continue;
            tIds.addAll(Arrays.asList(ids));
        }
        return tIds;
    }

    private BigInteger getTaxonomyIdFromListBySlug(String slug, List<Taxonomy> list) {
        for (Taxonomy taxonomy : list) {
            if (!slug.equals(taxonomy.getSlug())) continue;
            return taxonomy.getId();
        }
        return null;
    }

    @Before(value={UCodeInterceptor.class})
    public void save() {
        Content dbContent;
        Map metas = this.getMetas();
        Content content = this.getContent();
        if (StringUtils.isBlank((String)content.getTitle())) {
            this.renderAjaxResultForError("\u5185\u5bb9\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        boolean isAddAction = content.getId() == null;
        String slug = StringUtils.isBlank((String)content.getSlug()) ? content.getTitle() : content.getSlug();
        content.setSlug(slug);
        String username = this.getPara("username");
        if (StringUtils.isNotBlank((String)username)) {
            User user = UserQuery.me().findUserByUsername(username);
            if (user == null) {
                this.renderAjaxResultForError("\u7cfb\u7edf\u6ca1\u6709\u8be5\u7528\u6237\uff1a" + username);
                return;
            }
            content.setUserId(user.getId());
        }
        if ((dbContent = ContentQuery.me().findBySlug(content.getSlug())) != null && content.getId() != null && dbContent.getId().compareTo(content.getId()) != 0) {
            this.renderAjaxResultForError();
            return;
        }
        boolean saved = Db.tx((IAtom)new /* Unavailable Anonymous Inner Class!! */);
        if (!saved) {
            this.renderAjaxResultForError();
            return;
        }
        if (isAddAction) {
            MessageKit.sendMessage((String)"content:add", (Object)content);
        } else {
            MessageKit.sendMessage((String)"content:update", (Object)content);
        }
        AjaxResult ar = new AjaxResult();
        ar.setErrorCode(0);
        ar.setData((Object)content.getId());
        this.renderAjaxResult("save ok", 0, (Object)content.getId());
    }

    private Content getContent() {
        Content content = (Content)this.getModel(Content.class);
        content.setText(JsoupUtils.getBodyHtml((String)content.getText()));
        if (content.getCreated() == null) {
            content.setCreated(new Date());
        }
        content.setModified(new Date());
        User user = this.getLoginedUser();
        content.setUserId(user.getId());
        return content;
    }
}

