/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.JBaseCRUDController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.interceptor.UCodeInterceptor;
import io.jpress.model.Content;
import io.jpress.model.ModelSorter;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.template.TplTaxonomyType;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@RouterMapping(url="/admin/taxonomy", viewPath="/WEB-INF/admin/taxonomy")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _TaxonomyController
extends JBaseCRUDController<Taxonomy> {
    private String getContentModule() {
        return this.getPara("m");
    }

    private String getType() {
        return this.getPara("t");
    }

    public void index() {
        Page page;
        String moduleName = this.getContentModule();
        TplModule module = TemplateManager.me().currentTemplateModule(moduleName);
        TplTaxonomyType type = module.getTaxonomyTypeByType(this.getType());
        BigInteger id = this.getParaToBigInteger("id");
        List taxonomys = TaxonomyQuery.me().findListByModuleAndTypeAsSort(moduleName, type.getName());
        if (id != null) {
            Taxonomy taxonomy = TaxonomyQuery.me().findById(id);
            this.setAttr("taxonomy", (Object)taxonomy);
            Content content = ContentQuery.me().findFirstByModuleAndObjectId("menu", taxonomy.getId());
            if (content != null) {
                this.setAttr("addToMenuSelete", (Object)"checked=\"checked\"");
            }
        }
        if (id != null && taxonomys != null) {
            ModelSorter.removeTreeBranch((List)taxonomys, (BigInteger)id);
        }
        if ("select".equals(type.getFormType())) {
            page = TaxonomyQuery.me().doPaginate(1, Integer.MAX_VALUE, this.getContentModule(), this.getType());
            ModelSorter.sort((List)page.getList());
            this.setAttr("page", (Object)page);
        } else if ("input".equals(type.getFormType())) {
            page = TaxonomyQuery.me().doPaginate(this.getPageNumber(), this.getPageSize(), this.getContentModule(), this.getType());
            this.setAttr("page", (Object)page);
        }
        this.setAttr("module", (Object)module);
        this.setAttr("type", (Object)type);
        this.setAttr("taxonomys", (Object)taxonomys);
        String templateHtml = String.format("admin_taxonomy_index_%s_%s.html", moduleName, this.getType());
        for (int i = 0; i < 3; ++i) {
            if (TemplateManager.me().existsFile(templateHtml)) {
                this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
                return;
            }
            templateHtml = templateHtml.substring(0, templateHtml.lastIndexOf("_")) + ".html";
        }
        this.setAttr("include", (Object)"_index_include.html");
    }

    public void save() {
        Taxonomy m = (Taxonomy)this.getModel(Taxonomy.class);
        if (StringUtils.isBlank((String)m.getTitle())) {
            this.renderAjaxResultForError("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        if (StringUtils.isBlank((String)m.getSlug())) {
            this.renderAjaxResultForError("\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        if (StringUtils.isNumeric((String)m.getSlug())) {
            this.renderAjaxResultForError("\u522b\u540d\u4e0d\u80fd\u5168\u4e3a\u6570\u5b57\uff01");
            return;
        }
        if (m.getSlug() != null) {
            m.setSlug(m.getSlug());
        }
        Taxonomy dbTaxonomy = TaxonomyQuery.me().findBySlugAndModule(m.getSlug(), m.getContentModule());
        if (m.getId() != null && dbTaxonomy != null && m.getId().compareTo(dbTaxonomy.getId()) != 0) {
            this.renderAjaxResultForError("\u522b\u540d\u5df2\u7ecf\u5b58\u5728\uff01");
            return;
        }
        if (m.saveOrUpdate()) {
            boolean addToMenu = this.getParaToBoolean("addToMenu", Boolean.valueOf(false));
            if (addToMenu) {
                Content content = ContentQuery.me().findFirstByModuleAndObjectId("menu", m.getId());
                if (content == null) {
                    content = new Content();
                    content.setModule("menu");
                }
                content.setOrderNumber(Long.valueOf(0L));
                content.setText(m.getUrl());
                content.setTitle(m.getTitle());
                content.setObjectId(m.getId());
                content.saveOrUpdate();
            } else {
                Content content = ContentQuery.me().findFirstByModuleAndObjectId("menu", m.getId());
                if (content != null) {
                    content.delete();
                }
            }
            m.updateContentCount();
        }
        this.renderAjaxResultForSuccess("ok");
    }

    @Before(value={UCodeInterceptor.class})
    public void delete() {
        BigInteger id = this.getParaToBigInteger("id");
        if (id == null) {
            this.renderAjaxResultForError();
            return;
        }
        boolean deleted = Db.tx((IAtom)new /* Unavailable Anonymous Inner Class!! */);
        if (deleted) {
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void setting() {
        String moduleName = this.getContentModule();
        TplModule module = TemplateManager.me().currentTemplateModule(moduleName);
        TplTaxonomyType type = module.getTaxonomyTypeByType(this.getType());
        BigInteger id = this.getParaToBigInteger("id");
        Taxonomy taxonomy = TaxonomyQuery.me().findById(id);
        this.setAttr("taxonomy", (Object)taxonomy);
        this.setAttr("type", (Object)type);
        String templateHtml = String.format("admin_taxonomy_setting_%s_%s.html", moduleName, this.getType());
        for (int i = 0; i < 3; ++i) {
            if (TemplateManager.me().existsFile(templateHtml)) {
                this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
                return;
            }
            templateHtml = templateHtml.substring(0, templateHtml.lastIndexOf("_")) + ".html";
        }
        this.setAttr("include", (Object)"_setting_include.html");
    }

    @Before(value={UCodeInterceptor.class})
    public void doSaveSettings() {
        Map metas = this.getMetas();
        Taxonomy taxonomy = (Taxonomy)this.getModel(Taxonomy.class);
        boolean saved = Db.tx((IAtom)new /* Unavailable Anonymous Inner Class!! */);
        if (saved) {
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }
}

