/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.upload.UploadFile;
import io.jpress.core.JBaseController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.interceptor.UCodeInterceptor;
import io.jpress.menu.MenuManager;
import io.jpress.model.Content;
import io.jpress.model.ModelSorter;
import io.jpress.model.query.ContentQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.utils.FileUtils;
import io.jpress.utils.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RouterMapping(url="/admin/template", viewPath="/WEB-INF/admin/template")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _TemplateController
extends JBaseController {
    public void index() {
        List templateList = TemplateManager.me().getTemplates();
        this.setAttr("templateList", (Object)templateList);
        this.setAttr("currentTemplate", (Object)TemplateManager.me().currentTemplate());
    }

    public void enable() {
        String id = this.getPara("id");
        if (StringUtils.isBlank((String)id)) {
            this.renderAjaxResultForError();
            return;
        }
        boolean isSuccess = TemplateManager.me().doChangeTemplate(id);
        if (isSuccess) {
            MenuManager.me().refresh();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void install() {
        this.keepPara();
        if (this.isMultipartRequest()) {
            UploadFile ufile = this.getFile();
            if (ufile == null) {
                this.renderAjaxResultForError("\u60a8\u8fd8\u6ca1\u9009\u62e9\u6587\u4ef6\uff0c\u8bf7\u9009\u62e9zip\u683c\u5f0f\u7684\u6a21\u677f\u6587\u4ef6\uff01");
                return;
            }
            String webRoot = PathKit.getWebRootPath();
            StringBuilder newFileName = new StringBuilder(webRoot);
            newFileName.append(File.separator);
            newFileName.append("templates");
            newFileName.append(File.separator);
            newFileName.append(ufile.getFileName());
            File newfile = new File(newFileName.toString());
            if (newfile.exists()) {
                this.renderAjaxResultForError("\u8be5\u6a21\u677f\u5df2\u7ecf\u5b89\u88c5\uff01");
                return;
            }
            if (!newfile.getParentFile().exists()) {
                newfile.getParentFile().mkdirs();
            }
            ufile.getFile().renameTo(newfile);
            String zipPath = newfile.getAbsolutePath();
            try {
                FileUtils.unzip((String)zipPath, (String)newfile.getParentFile().getAbsolutePath());
            }
            catch (IOException e) {
                this.renderAjaxResultForError("\u6a21\u677f\u6587\u4ef6\u89e3\u538b\u7f29\u5931\u8d25\uff01");
                return;
            }
            this.renderAjaxResultForSuccess();
        }
    }

    public void edit() {
        String fileContent;
        this.keepPara();
        String path = TemplateManager.me().currentTemplatePath();
        File pathFile = new File(PathKit.getWebRootPath(), path);
        File[] dirs = pathFile.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.setAttr("dirs", (Object)dirs);
        String dirName = this.getPara("d");
        if (dirName != null) {
            pathFile = new File(pathFile, dirName);
        }
        File[] files = pathFile.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.setAttr("files", (Object)files);
        String fileName = this.getPara("f", "index.html");
        File editFile = null;
        if (fileName != null && files != null && files.length > 0) {
            for (File f : files) {
                if (!fileName.equals(f.getName())) continue;
                editFile = f;
                break;
            }
            if (editFile == null) {
                editFile = files[0];
                fileName = editFile.getName();
            }
        }
        this.setAttr("f", (Object)fileName);
        if (editFile != null && (fileContent = FileUtils.readString(editFile)) != null) {
            fileContent = fileContent.replace("<", "&lt;").replace(">", "&gt;");
            this.setAttr("fileContent", (Object)fileContent);
            this.setAttr("editFile", (Object)editFile);
        }
    }

    public void editsave() {
        String path = TemplateManager.me().currentTemplatePath();
        File pathFile = new File(PathKit.getWebRootPath(), path);
        String dirName = this.getPara("d");
        if (dirName != null) {
            pathFile = new File(pathFile, dirName);
        }
        String fileName = this.getPara("f");
        String fileContent = this.getRequest().getParameter("fileContent");
        fileContent = fileContent.replace("&lt;", "<").replace("&gt;", ">");
        File file = new File(pathFile, fileName);
        FileUtils.writeString((File)file, (String)fileContent);
        this.renderAjaxResultForSuccess();
    }

    public void menu() {
        List list = ContentQuery.me().findByModule("menu", null, "order_number ASC");
        ModelSorter.sort((List)list);
        ArrayList menulist = new ArrayList();
        menulist.addAll(list);
        BigInteger id = this.getParaToBigInteger("id");
        if (id != null) {
            Content c = ContentQuery.me().findById(id);
            this.setAttr("menu", (Object)c);
            if (id != null && list != null) {
                ModelSorter.removeTreeBranch((List)list, (BigInteger)id);
            }
        }
        this.setAttr("menus", (Object)list);
        this.setAttr("menulist", menulist);
    }

    @Before(value={UCodeInterceptor.class})
    public void menusave() {
        Content c = (Content)this.getModel(Content.class);
        if (StringUtils.isBlank((String)c.getTitle())) {
            this.renderAjaxResultForError("\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        c.setModule("menu");
        c.setModified(new Date());
        if (c.getCreated() == null) {
            c.setCreated(new Date());
        }
        c.setStatus(Content.STATUS_NORMAL);
        c.saveOrUpdate();
        this.renderAjaxResultForSuccess();
    }

    @Before(value={UCodeInterceptor.class})
    public void menudel() {
        boolean deleted;
        BigInteger id = this.getParaToBigInteger("id");
        if (id == null) {
            this.renderAjaxResultForError();
        }
        if (deleted = Db.tx((IAtom)new /* Unavailable Anonymous Inner Class!! */)) {
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void setting() {
        this.keepPara();
        if (TemplateManager.me().existsFile("tpl_setting.html")) {
            this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/tpl_setting.html"));
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void settingsave() {
        this.keepPara();
        this.renderAjaxResultForSuccess("\u6210\u529f\uff01");
    }
}

