/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.core.JFinal;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import com.jfinal.render.Render;
import com.jfinal.upload.UploadFile;
import io.jpress.admin.controller._TinymceImageController;
import io.jpress.core.JBaseController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.model.Attachment;
import io.jpress.model.User;
import io.jpress.model.query.OptionQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.template.Thumbnail;
import io.jpress.utils.AttachmentUtils;
import io.jpress.utils.FileUtils;
import io.jpress.utils.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;

@RouterMapping(url="/admin/tinymce/image")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _TinymceImageController
extends JBaseController {
    private static final Log log = Log.getLog(_TinymceImageController.class);

    public void proxy() {
        String url = this.getPara("url");
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setInstanceFollowRedirects(true);
            conn.setUseCaches(true);
            InputStream is = conn.getInputStream();
            this.setHeader("Content-Type", conn.getContentType());
            this.render((Render)new StreamRender(this, is));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void upload() {
        UploadFile uploadFile = this.getFile();
        String newPath = AttachmentUtils.moveFile((UploadFile)uploadFile);
        User user = this.getLoginedUser();
        Attachment attachment = new Attachment();
        attachment.setUserId(user.getId());
        attachment.setCreated(new Date());
        attachment.setTitle(uploadFile.getOriginalFileName());
        attachment.setPath(newPath.replace("\\", "/"));
        attachment.setSuffix(FileUtils.getSuffix((String)uploadFile.getFileName()));
        attachment.setMimeType(uploadFile.getContentType());
        attachment.save();
        this.processImage(newPath);
        this.renderJson("location", (Object)(JFinal.me().getContextPath() + newPath));
    }

    private void processImage(String newPath) {
        if (!AttachmentUtils.isImage((String)newPath)) {
            return;
        }
        if (".gif".equalsIgnoreCase(FileUtils.getSuffix((String)newPath))) {
            return;
        }
        try {
            this.processThumbnail(newPath);
        }
        catch (Throwable e) {
            log.error("processThumbnail error", e);
        }
        try {
            this.processWatermark(newPath);
        }
        catch (Throwable e) {
            log.error("processWatermark error", e);
        }
    }

    private void processThumbnail(String newPath) {
        List tbs = TemplateManager.me().currentTemplate().getThumbnails();
        if (tbs != null && tbs.size() > 0) {
            for (Thumbnail tb : tbs) {
                try {
                    String newSrc = ImageUtils.scale((String)(PathKit.getWebRootPath() + newPath), (int)tb.getWidth(), (int)tb.getHeight());
                    this.processWatermark(FileUtils.removeRootPath((String)newSrc));
                }
                catch (IOException e) {
                    log.error("processWatermark error", (Throwable)e);
                }
            }
        }
    }

    public void processWatermark(String newPath) {
        Boolean watermark_enable = OptionQuery.me().findValueAsBool("watermark_enable");
        if (watermark_enable != null && watermark_enable.booleanValue()) {
            int position = OptionQuery.me().findValueAsInteger("watermark_position");
            String watermarkImg = OptionQuery.me().findValue("watermark_image");
            String srcImageFile = newPath;
            Float transparency = OptionQuery.me().findValueAsFloat("watermark_transparency");
            if (transparency == null || transparency.floatValue() < 0.0f || transparency.floatValue() > 1.0f) {
                transparency = Float.valueOf(1.0f);
            }
            srcImageFile = PathKit.getWebRootPath() + srcImageFile;
            File watermarkFile = new File(PathKit.getWebRootPath(), watermarkImg);
            if (!watermarkFile.exists()) {
                return;
            }
            ImageUtils.pressImage((String)watermarkFile.getAbsolutePath(), (String)srcImageFile, (String)srcImageFile, (int)position, (float)transparency.floatValue());
        }
    }
}

