/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.jfinal.aop.Before;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.JBaseCRUDController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.model.User;
import io.jpress.model.query.UserQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.utils.EncryptUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@RouterMapping(url="/admin/user", viewPath="/WEB-INF/admin/user")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _UserController
extends JBaseCRUDController<User> {
    public void index() {
        this.setAttr("userCount", (Object)UserQuery.me().findCount());
        this.setAttr("adminCount", (Object)UserQuery.me().findAdminCount());
        Page page = UserQuery.me().paginate(this.getPageNumber(), this.getPageSize(), null);
        this.setAttr("page", (Object)page);
        String templateHtml = "admin_user_index.html";
        if (TemplateManager.me().existsFile(templateHtml)) {
            this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
            return;
        }
        this.setAttr("include", (Object)"_index_include.html");
    }

    public void edit() {
        BigInteger id = this.getParaToBigInteger("id");
        if (id != null) {
            this.setAttr("user", (Object)UserQuery.me().findById(id));
        }
        String templateHtml = "admin_user_edit.html";
        if (TemplateManager.me().existsFile(templateHtml)) {
            this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
            return;
        }
        this.setAttr("include", (Object)"_edit_include.html");
    }

    public void save() {
        boolean saved;
        User dbUser;
        HashMap files = this.getUploadFilesMap();
        Map metas = this.getMetas((Map)files);
        User user = (User)this.getModel(User.class);
        String password = user.getPassword();
        if (StringUtils.isBlank((String)user.getUsername())) {
            this.renderAjaxResultForError("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return;
        }
        if (user.getId() == null) {
            dbUser = UserQuery.me().findUserByUsername(user.getUsername());
            if (dbUser != null) {
                this.renderAjaxResultForError("\u8be5\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u6dfb\u52a0\u3002");
                return;
            }
            if (StringUtils.isNotBlank((String)user.getEmail()) && (dbUser = UserQuery.me().findUserByEmail(user.getEmail())) != null) {
                this.renderAjaxResultForError("\u90ae\u4ef6\u5730\u5740\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u6dfb\u52a0\u8be5\u90ae\u7bb1\u3002");
                return;
            }
            if (StringUtils.isNotBlank((String)user.getMobile()) && (dbUser = UserQuery.me().findUserByMobile(user.getMobile())) != null) {
                this.renderAjaxResultForError("\u624b\u673a\u53f7\u7801\u5730\u5740\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u6dfb\u52a0\u8be5\u624b\u673a\u53f7\u7801\u3002");
                return;
            }
            String salt = EncryptUtils.salt();
            user.setSalt(salt);
            user.setCreated(new Date());
            if (StringUtils.isNotEmpty((String)password)) {
                password = EncryptUtils.encryptPassword((String)password, (String)salt);
                user.setPassword(password);
            }
        } else {
            if (StringUtils.isNotBlank((String)user.getEmail()) && (dbUser = UserQuery.me().findUserByEmail(user.getEmail())) != null && user.getId().compareTo(dbUser.getId()) != 0) {
                this.renderAjaxResultForError("\u90ae\u4ef6\u5730\u5740\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u4fee\u6539\u4e3a\u8be5\u90ae\u7bb1\u3002");
                return;
            }
            if (StringUtils.isNotBlank((String)user.getMobile()) && (dbUser = UserQuery.me().findUserByMobile(user.getMobile())) != null && user.getId().compareTo(dbUser.getId()) != 0) {
                this.renderAjaxResultForError("\u624b\u673a\u53f7\u7801\u5730\u5740\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u4fee\u4fee\u6539\u4e3a\u8be5\u624b\u673a\u53f7\u7801\u3002");
                return;
            }
            if (StringUtils.isNotEmpty((String)password)) {
                dbUser = UserQuery.me().findById(user.getId());
                user.setSalt(dbUser.getSalt());
                password = EncryptUtils.encryptPassword((String)password, (String)dbUser.getSalt());
                user.setPassword(password);
            } else {
                user.remove("password");
            }
        }
        if (files != null && files.containsKey("user.avatar")) {
            user.setAvatar((String)files.get("user.avatar"));
        }
        if (saved = Db.tx((IAtom)new /* Unavailable Anonymous Inner Class!! */)) {
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
        user.saveOrUpdate();
        this.renderAjaxResultForSuccess("ok");
    }

    public void info() {
        User user = this.getLoginedUser();
        if (user != null) {
            user = UserQuery.me().findById(user.getId());
        }
        this.setAttr("user", (Object)user);
        String templateHtml = "admin_user_info.html";
        if (TemplateManager.me().existsFile(templateHtml)) {
            this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
            this.render("edit.html");
            return;
        }
        templateHtml = "admin_user_edit.html";
        if (TemplateManager.me().existsFile(templateHtml)) {
            this.setAttr("include", (Object)(TemplateManager.me().currentTemplatePath() + "/" + templateHtml));
            this.render("edit.html");
            return;
        }
        this.setAttr("include", (Object)"_edit_include.html");
        this.render("edit.html");
    }

    public void frozen() {
        BigInteger id = this.getParaToBigInteger("id");
        if (id != null) {
            User user = UserQuery.me().findById(id);
            user.setStatus("frozen");
            user.update();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void restore() {
        BigInteger id = this.getParaToBigInteger("id");
        if (id != null) {
            User user = UserQuery.me().findById(id);
            user.setStatus("normal");
            user.update();
            this.renderAjaxResultForSuccess();
        } else {
            this.renderAjaxResultForError();
        }
    }

    public void delete() {
        BigInteger id = this.getParaToBigInteger("id");
        if (id == null) {
            this.renderAjaxResultForError();
            return;
        }
        User user = this.getLoginedUser();
        if (user.getId().compareTo(id) == 0) {
            this.renderAjaxResultForError("\u4e0d\u80fd\u5220\u9664\u81ea\u5df1...");
            return;
        }
        super.delete();
    }
}

