/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.admin.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.aop.Before;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.api.ReturnCode;
import io.jpress.core.JBaseCRUDController;
import io.jpress.core.interceptor.ActionCacheClearInterceptor;
import io.jpress.interceptor.UCodeInterceptor;
import io.jpress.model.Content;
import io.jpress.model.ModelSorter;
import io.jpress.model.query.ContentQuery;
import io.jpress.router.RouterMapping;
import io.jpress.router.RouterNotAllowConvert;
import io.jpress.template.TemplateManager;
import io.jpress.utils.StringUtils;
import io.jpress.wechat.WechatApi;
import io.jpress.wechat.WechatApiConfigInterceptor;
import io.jpress.wechat.WechatConsts;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RouterMapping(url="/admin/wechat", viewPath="/WEB-INF/admin/wechat")
@Before(value={ActionCacheClearInterceptor.class})
@RouterNotAllowConvert
public class _WechatController
extends JBaseCRUDController<Content> {
    private String getStatus() {
        return this.getPara("s");
    }

    public Page<Content> onIndexDataLoad(int pageNumber, int pageSize) {
        if (this.getStatus() != null && !"".equals(this.getStatus().trim())) {
            return ContentQuery.me().paginateByModuleAndStatus(pageNumber, pageSize, "wechat_reply", this.getStatus());
        }
        return ContentQuery.me().paginateByModuleInNormal(pageNumber, pageSize, "wechat_reply");
    }

    public void reply_default() {
    }

    public void reply_advanced() {
    }

    public void option() {
        this.setAttr("modules", (Object)TemplateManager.me().currentTemplateModules());
    }

    public void menu() {
        List list = ContentQuery.me().findByModule("wechat_menu", null, "order_number ASC");
        ModelSorter.sort((List)list);
        ArrayList wechat_menulist = new ArrayList();
        wechat_menulist.addAll(list);
        BigInteger id = this.getParaToBigInteger("id");
        if (id != null) {
            Content c = ContentQuery.me().findById(id);
            this.setAttr("wechat_menu", (Object)c);
            this.setAttr(c.getFlag() + "_selected", (Object)"selected=\"selected\"");
            if (id != null && list != null) {
                ModelSorter.removeTreeBranch((List)list, (BigInteger)id);
            }
        }
        this.setAttr("wechat_menus", (Object)list);
        this.setAttr("wechat_menulist", wechat_menulist);
    }

    @Before(value={UCodeInterceptor.class})
    public void menuSave() {
        Content c = (Content)this.getModel(Content.class);
        if (StringUtils.isBlank((String)c.getTitle())) {
            this.renderAjaxResultForError("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        if (StringUtils.isBlank((String)c.getText())) {
            this.renderAjaxResultForError("\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        if (c.getParentId() == null) {
            long count = ContentQuery.me().findCountInNormalByParentId(null, "wechat_menu");
            if (count > 3L) {
                this.renderAjaxResultForError("\u9876\u7ea7\u83dc\u5355\u4e0d\u80fd\u8d85\u8fc73\u4e2a\uff01");
                return;
            }
        } else {
            long count = ContentQuery.me().findCountInNormalByParentId(null, "wechat_menu");
            if (count > 5L) {
                this.renderAjaxResultForError("\u5b50\u7ea7\u83dc\u5355\u4e0d\u80fd\u8d85\u8fc75\u4e2a\uff01");
                return;
            }
        }
        c.setStatus(Content.STATUS_NORMAL);
        c.setModule("wechat_menu");
        c.setModified(new Date());
        if (c.getCreated() == null) {
            c.setCreated(new Date());
        }
        c.saveOrUpdate();
        this.renderAjaxResultForSuccess();
    }

    @Before(value={UCodeInterceptor.class})
    public void menuDel() {
        BigInteger id = this.getParaToBigInteger("id");
        if (id != null && ContentQuery.me().deleteById(id)) {
            this.renderAjaxResultForSuccess();
        }
        this.renderAjaxResultForSuccess();
    }

    @Before(value={WechatApiConfigInterceptor.class})
    public void menuSync() {
        List wechatMenus = ContentQuery.me().findByModule("wechat_menu", null, "order_number ASC");
        ModelSorter.tree((List)wechatMenus);
        if (wechatMenus != null) {
            JSONArray button = new JSONArray();
            for (Content content : wechatMenus) {
                JSONObject jsonObject;
                if (content.hasChild()) {
                    jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)content.getTitle());
                    List childMenus = content.getChildList();
                    JSONArray sub_buttons = new JSONArray();
                    for (Content c : childMenus) {
                        JSONObject sub_button = new JSONObject();
                        sub_button.put("type", (Object)c.getFlag());
                        sub_button.put("name", (Object)c.getTitle());
                        if ("view".equals(c.getFlag())) {
                            sub_button.put("url", (Object)c.getText());
                        } else {
                            sub_button.put("key", (Object)c.getText());
                        }
                        sub_buttons.add((Object)sub_button);
                    }
                    jsonObject.put("sub_button", (Object)sub_buttons);
                    button.add((Object)jsonObject);
                    continue;
                }
                jsonObject = new JSONObject();
                jsonObject.put("type", (Object)content.getFlag());
                jsonObject.put("name", (Object)content.getTitle());
                if ("view".equals(content.getFlag())) {
                    jsonObject.put("url", (Object)content.getText());
                } else {
                    jsonObject.put("key", (Object)content.getText());
                }
                button.add((Object)jsonObject);
            }
            JSONObject wechatMenuJson = new JSONObject();
            wechatMenuJson.put("button", (Object)button);
            String jsonString = wechatMenuJson.toJSONString();
            ApiResult result = WechatApi.createMenu((String)jsonString);
            if (result.isSucceed()) {
                this.renderAjaxResultForSuccess();
            } else {
                String message = WechatConsts.getErrorMessage((int)result.getErrorCode());
                if (StringUtils.isBlank((String)message)) {
                    message = ReturnCode.get((int)result.getErrorCode());
                }
                if (StringUtils.isBlank((String)message)) {
                    message = "\u672a\u77e5\u9519\u8bef";
                }
                this.renderAjaxResult(message, result.getErrorCode().intValue());
            }
        } else {
            this.renderAjaxResultForError("\u8fd8\u6ca1\u6709\u6dfb\u52a0\u83dc\u5355\u4fe1\u606f");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void trash() {
        BigInteger id = this.getParaToBigInteger("id");
        Content c = ContentQuery.me().findById(id);
        if (c != null) {
            c.setStatus(Content.STATUS_DELETE);
            c.saveOrUpdate();
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("trash error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void batchTrash() {
        BigInteger[] ids = this.getParaValuesToBigInteger("dataItem");
        int count = ContentQuery.me().batchTrash(ids);
        if (count > 0) {
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("trash error!");
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void delete() {
        BigInteger id = this.getParaToBigInteger("id");
        Content c = ContentQuery.me().findById(id);
        if (c != null && c.isDelete()) {
            c.delete();
            this.renderAjaxResultForSuccess("success");
        } else {
            this.renderAjaxResultForError("restore error!");
        }
    }

    public void edit() {
        String id = this.getPara("id");
        if (id != null) {
            this.setAttr("content", (Object)ContentQuery.me().findById((Object)id));
        } else {
            Content c = new Content();
            c.setCreated(new Date());
            this.setAttr("content", (Object)c);
        }
        this.render("edit.html");
    }

    @Before(value={UCodeInterceptor.class})
    public void save() {
        Content content = (Content)this.getModel(Content.class);
        content.saveOrUpdate();
        this.renderAjaxResultForSuccess();
    }
}

