/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core;

import com.jfinal.core.Controller;
import io.jpress.core.JBaseController;
import io.jpress.template.TemplateManager;
import io.jpress.utils.StringUtils;

public class BaseFrontController
extends JBaseController {
    private static final String FILE_SEPARATOR = "_";
    private String renderFile = null;

    public void render(String name) {
        this.renderFile = null;
        this.initRenderFile(name);
        if (this.renderFile != null) {
            super.render(this.renderFile);
        } else {
            this.renderError(404);
        }
    }

    private void initRenderFile(String name) {
        if (this.isWechatBrowser()) {
            this.initWechatFile(name);
            if (this.renderFile == null) {
                this.initMobileFile(name);
            }
        }
        if (this.isMoblieBrowser()) {
            this.initMobileFile(name);
        }
        if (this.renderFile == null) {
            this.initNormalFile(name);
        }
    }

    public boolean templateExists(String file) {
        boolean isExists = false;
        if (this.isWechatBrowser() && !(isExists = TemplateManager.me().existsFileInWechat(file))) {
            isExists = TemplateManager.me().existsFileInMobile(file);
        }
        if (this.isMoblieBrowser()) {
            isExists = TemplateManager.me().existsFileInMobile(file);
        }
        if (!isExists) {
            isExists = TemplateManager.me().existsFile(file);
        }
        return isExists;
    }

    private void initWechatFile(String name) {
        if (name.contains(FILE_SEPARATOR)) {
            do {
                if (!TemplateManager.me().existsFileInWechat(name)) continue;
                this.renderFile = this.buildWechatPath(name);
                return;
            } while ((name = this.clearProp(name)).contains(FILE_SEPARATOR));
        }
        if (TemplateManager.me().existsFileInWechat(name)) {
            this.renderFile = this.buildWechatPath(name);
        }
    }

    private void initMobileFile(String name) {
        if (name.contains(FILE_SEPARATOR)) {
            do {
                if (!TemplateManager.me().existsFileInMobile(name)) continue;
                this.renderFile = this.buildMobilePath(name);
                return;
            } while ((name = this.clearProp(name)).contains(FILE_SEPARATOR));
        }
        if (TemplateManager.me().existsFileInMobile(name)) {
            this.renderFile = this.buildMobilePath(name);
        }
    }

    private void initNormalFile(String name) {
        if (name.contains(FILE_SEPARATOR)) {
            do {
                if (!TemplateManager.me().existsFile(name)) continue;
                this.renderFile = this.buildPath(name);
                return;
            } while ((name = this.clearProp(name)).contains(FILE_SEPARATOR));
        }
        if (TemplateManager.me().existsFile(name)) {
            this.renderFile = this.buildPath(name);
            return;
        }
    }

    private String buildPath(String name) {
        return TemplateManager.me().currentTemplate().getPath() + "/" + name;
    }

    private String buildWechatPath(String name) {
        return TemplateManager.me().currentTemplate().getPath() + "/tpl_wechat/" + name;
    }

    private String buildMobilePath(String name) {
        return TemplateManager.me().currentTemplate().getPath() + "/tpl_mobile/" + name;
    }

    public String clearProp(String fname) {
        return fname.substring(0, fname.lastIndexOf(FILE_SEPARATOR)) + ".html";
    }

    public Controller keepPara() {
        super.keepPara();
        String gotoUrl = this.getPara("goto");
        if (StringUtils.isNotBlank((String)gotoUrl)) {
            this.setAttr("goto", (Object)StringUtils.urlEncode((String)gotoUrl));
        }
        return this;
    }
}

