/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core;

import com.jfinal.core.Controller;
import com.jfinal.core.JFinal;
import com.jfinal.plugin.ehcache.CacheKit;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class JSession
implements HttpSession {
    final Controller controller;
    private static final int TIME = 604800;

    public JSession(Controller controller) {
        this.controller = controller;
    }

    private void doPut(String key, Object value) {
        CacheKit.put((String)"session", (Object)(key + this.tryToGetJsessionId()), (Object)value);
    }

    private void doRemove(String key) {
        CacheKit.remove((String)"session", (Object)(key + this.tryToGetJsessionId()));
    }

    private Object doGet(String key) {
        return CacheKit.get((String)"session", (Object)(key + this.tryToGetJsessionId()));
    }

    private String tryToGetJsessionId() {
        String sessionid = this.controller.getCookie("JPSESSIONID");
        if (sessionid == null || "".equals(sessionid.trim())) {
            sessionid = UUID.randomUUID().toString().replace("-", "");
            this.controller.setCookie("JPSESSIONID", sessionid, 604800, true);
        }
        return sessionid;
    }

    public Object getAttribute(String key) {
        return this.doGet(key);
    }

    public Enumeration<String> getAttributeNames() {
        throw new RuntimeException("getAttributeNames method not finished.");
    }

    public long getCreationTime() {
        return 0L;
    }

    public String getId() {
        return this.tryToGetJsessionId();
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public ServletContext getServletContext() {
        return JFinal.me().getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        throw new RuntimeException("getAttributeNames method not finished.");
    }

    public Object getValue(String key) {
        return this.doGet(key);
    }

    public String[] getValueNames() {
        return null;
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return false;
    }

    public void putValue(String key, Object value) {
        this.doPut(key, value);
    }

    public void removeAttribute(String key) {
        this.doRemove(key);
    }

    public void removeValue(String key) {
        this.doRemove(key);
    }

    public void setAttribute(String key, Object value) {
        this.doPut(key, value);
    }

    public void setMaxInactiveInterval(int arg0) {
    }
}

