/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core;

import com.jfinal.aop.Interceptor;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.core.JFinal;
import com.jfinal.handler.Handler;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.druid.DruidPlugin;
import com.jfinal.plugin.ehcache.EhCachePlugin;
import com.jfinal.render.IErrorRenderFactory;
import com.jfinal.render.IMainRenderFactory;
import com.jfinal.render.ViewType;
import io.jpress.core.JHandler;
import io.jpress.core.Jpress;
import io.jpress.core.MyDruidStatViewHandler;
import io.jpress.core.cache.ActionCacheHandler;
import io.jpress.core.db.DbDialect;
import io.jpress.core.db.DbDialectFactory;
import io.jpress.core.interceptor.HookInterceptor;
import io.jpress.core.interceptor.JI18nInterceptor;
import io.jpress.core.render.JErrorRenderFactory;
import io.jpress.core.render.JpressRenderFactory;
import io.jpress.interceptor.AdminInterceptor;
import io.jpress.interceptor.GlobelInterceptor;
import io.jpress.message.plugin.MessagePlugin;
import io.jpress.model.core.Table;
import io.jpress.router.RouterMapping;
import io.jpress.utils.ClassScaner;
import io.jpress.utils.StringUtils;
import java.io.File;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.List;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;

public abstract class JpressConfig
extends JFinalConfig {
    static Log log = Log.getLog(JpressConfig.class);

    public void configConstant(Constants constants) {
        log.info("JPress is starting ...");
        PropKit.use((String)"jpress.properties");
        this.onJfinalStartBefore();
        constants.setDevMode(PropKit.getBoolean((String)"dev_mode", (Boolean)false).booleanValue());
        constants.setViewType(ViewType.FREE_MARKER);
        constants.setI18nDefaultBaseName("language");
        constants.setErrorRenderFactory((IErrorRenderFactory)new JErrorRenderFactory());
        constants.setBaseUploadPath("attachment");
        constants.setEncoding("UTF-8");
        constants.setMaxPostSize(0xC800000);
        constants.setMainRenderFactory((IMainRenderFactory)new JpressRenderFactory());
    }

    public void configRoute(Routes routes) {
        List controllerClassList = ClassScaner.scanSubClass(Controller.class);
        if (controllerClassList != null) {
            for (Class clazz : controllerClassList) {
                RouterMapping urlMapping = clazz.getAnnotation(RouterMapping.class);
                if (null == urlMapping || !StringUtils.isNotBlank((String)urlMapping.url())) continue;
                if (StrKit.notBlank((String)urlMapping.viewPath())) {
                    routes.add(urlMapping.url(), clazz, urlMapping.viewPath());
                    continue;
                }
                routes.add(urlMapping.url(), clazz);
            }
        }
    }

    public void configPlugin(Plugins plugins) {
        plugins.add((IPlugin)this.createEhCachePlugin());
        if (Jpress.isInstalled()) {
            DruidPlugin druidPlugin = this.createDruidPlugin();
            plugins.add((IPlugin)druidPlugin);
            ActiveRecordPlugin activeRecordPlugin = this.createRecordPlugin((IDataSourceProvider)druidPlugin);
            plugins.add((IPlugin)activeRecordPlugin);
            plugins.add((IPlugin)new MessagePlugin());
        }
    }

    public EhCachePlugin createEhCachePlugin() {
        String ehcacheDiskStorePath = PathKit.getWebRootPath();
        File pathFile = new File(ehcacheDiskStorePath, ".ehcache");
        Configuration cfg = ConfigurationFactory.parseConfiguration();
        cfg.addDiskStore(new DiskStoreConfiguration().path(pathFile.getAbsolutePath()));
        return new EhCachePlugin(cfg);
    }

    public DruidPlugin createDruidPlugin() {
        Prop dbProp = PropKit.use((String)"db.properties");
        String db_host = dbProp.get("db_host").trim();
        String db_host_port = dbProp.get("db_host_port");
        db_host_port = StringUtils.isNotBlank((String)db_host_port) ? db_host_port.trim() : "3306";
        String db_name = dbProp.get("db_name").trim();
        String db_user = dbProp.get("db_user").trim();
        String db_password = dbProp.get("db_password").trim();
        return DbDialectFactory.getDbDialect().createDuidPlugin(db_host, db_host_port, db_name, db_user, db_password);
    }

    public ActiveRecordPlugin createRecordPlugin(IDataSourceProvider dsp) {
        ActiveRecordPlugin arPlugin = new ActiveRecordPlugin(dsp);
        List modelClassList = ClassScaner.scanSubClass(Model.class);
        if (modelClassList != null) {
            String tablePrefix = PropKit.use((String)"db.properties").get("db_tablePrefix");
            tablePrefix = StrKit.isBlank((String)tablePrefix) ? "" : tablePrefix.trim();
            for (Class clazz : modelClassList) {
                Table tb = clazz.getAnnotation(Table.class);
                if (tb == null) continue;
                String tname = tablePrefix + tb.tableName();
                if (StringUtils.isNotBlank((String)tb.primaryKey())) {
                    arPlugin.addMapping(tname, tb.primaryKey(), clazz);
                } else {
                    arPlugin.addMapping(tname, clazz);
                }
                DbDialect.mapping((String)clazz.getSimpleName().toLowerCase(), (String)tname);
            }
        }
        arPlugin.setShowSql(JFinal.me().getConstants().getDevMode());
        return arPlugin;
    }

    public void configInterceptor(Interceptors interceptors) {
        interceptors.add((Interceptor)new JI18nInterceptor());
        interceptors.add((Interceptor)new GlobelInterceptor());
        interceptors.add((Interceptor)new AdminInterceptor());
        interceptors.add((Interceptor)new HookInterceptor());
    }

    public void configHandler(Handlers handlers) {
        handlers.add((Handler)new ActionCacheHandler());
        handlers.add((Handler)new JHandler());
        handlers.add((Handler)new ActionCacheHandler());
        MyDruidStatViewHandler druidViewHandler = new MyDruidStatViewHandler();
        handlers.add((Handler)druidViewHandler);
    }

    public void afterJFinalStart() {
        if (Jpress.isInstalled()) {
            Jpress.loadFinished();
        }
        Jpress.renderImmediately();
        this.onJfinalStartAfter();
        log.info("JPress is started!");
    }

    public void beforeJFinalStop() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        if (drivers != null) {
            while (drivers.hasMoreElements()) {
                try {
                    Driver driver = drivers.nextElement();
                    DriverManager.deregisterDriver(driver);
                }
                catch (Exception e) {
                    log.error("deregisterDriver error in beforeJFinalStop() method.", (Throwable)e);
                }
            }
        }
    }

    public abstract void onJfinalStartAfter();

    public abstract void onJfinalStartBefore();
}

