/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.render;

import com.jfinal.render.IErrorRenderFactory;
import com.jfinal.render.Render;
import com.jfinal.render.TextRender;
import io.jpress.core.Jpress;
import io.jpress.core.render.JFreemarkerRender;
import io.jpress.core.render.ThymeleafRender;
import io.jpress.template.Template;
import io.jpress.template.TemplateManager;
import io.jpress.utils.StringUtils;

public class JErrorRenderFactory
implements IErrorRenderFactory {
    public Render getRender(int errorCode, String view) {
        if (!Jpress.isInstalled()) {
            return new TextRender(errorCode + " error in jpress.");
        }
        Template template = TemplateManager.me().currentTemplate();
        if (null == template) {
            return new TextRender(String.format("%s error! you haven't configure your template yet.", errorCode));
        }
        String errorHtml = TemplateManager.me().currentTemplatePath() + "/" + errorCode + ".html";
        String renderType = TemplateManager.me().currentTemplate().getRenderType();
        if (StringUtils.isBlank((String)renderType)) {
            return new JFreemarkerRender(errorHtml, true);
        }
        if ("freemarker".equalsIgnoreCase(renderType)) {
            return new JFreemarkerRender(errorHtml, true);
        }
        if ("thymeleaf".equalsIgnoreCase(renderType)) {
            return new ThymeleafRender(errorHtml);
        }
        return new TextRender(errorCode + " error in jpress.");
    }
}

