/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.core.render;

import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.RenderException;
import freemarker.template.Template;
import io.jpress.core.Jpress;
import io.jpress.core.cache.ActionCacheManager;
import io.jpress.model.query.OptionQuery;
import io.jpress.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * Exception performing whole class analysis ignored.
 */
public class JFreemarkerRender
extends FreeMarkerRender {
    private boolean enableCdnProcess;

    public JFreemarkerRender(String view, boolean enableCdnProcess) {
        super(view);
        this.enableCdnProcess = enableCdnProcess;
    }

    public void render() {
        HashMap<String, Object> jpTags = new HashMap<String, Object>();
        jpTags.putAll(Jpress.jpressTags);
        HashMap<String, Object> data = new HashMap<String, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            if (attrName.startsWith("jp.")) {
                jpTags.put(attrName.substring(3), this.request.getAttribute(attrName));
                continue;
            }
            data.put(attrName, this.request.getAttribute(attrName));
        }
        data.put("jp", jpTags);
        String htmlContent = this.getHtmlContent(data);
        if (this.enableCdnProcess) {
            htmlContent = this.processCDN(htmlContent);
        }
        if (ActionCacheManager.isCloseActionCache()) {
            this.WriterHtml(htmlContent, this.getContentType(), false);
            return;
        }
        if (!ActionCacheManager.isEnableCache((HttpServletRequest)this.request)) {
            this.WriterHtml(htmlContent, this.getContentType(), false);
            return;
        }
        this.WriterHtml(htmlContent, ActionCacheManager.getCacheContentType((HttpServletRequest)this.request), true);
    }

    private void WriterHtml(String htmlContent, String contentType, boolean putCache) {
        this.response.setContentType(contentType);
        PrintWriter responseWriter = null;
        try {
            responseWriter = this.response.getWriter();
            responseWriter.write(htmlContent);
            if (putCache) {
                ActionCacheManager.putCache((HttpServletRequest)this.request, (Object)htmlContent);
            }
        }
        catch (Exception e) {
            if (Jpress.isDevMode()) {
                e.printStackTrace();
            }
            throw new RenderException((Throwable)e);
        }
        finally {
            this.close((Writer)responseWriter);
        }
    }

    private String getHtmlContent(Map data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osWriter = null;
        try {
            osWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Template template = JFreemarkerRender.getConfiguration().getTemplate(this.view);
            template.process((Object)data, (Writer)osWriter);
            osWriter.flush();
            String string = baos.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            if (Jpress.isDevMode()) {
                e.printStackTrace();
            }
            throw new RenderException((Throwable)e);
        }
        finally {
            this.close((OutputStream)baos);
            this.close((Writer)osWriter);
        }
    }

    private void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String processCDN(String content) {
        Boolean cdnEnable = OptionQuery.me().findValueAsBool("cdn_enable");
        if (cdnEnable == null || !cdnEnable.booleanValue()) {
            return content;
        }
        String cdnDomain = OptionQuery.me().findValue("cdn_domain");
        if (StringUtils.isBlank((String)cdnDomain)) {
            return content;
        }
        Document doc = Jsoup.parse((String)content);
        Elements jsElements = doc.select("script[src]");
        JFreemarkerRender.replace((Elements)jsElements, (String)"src", (String)cdnDomain);
        Elements imgElements = doc.select("img[src]");
        JFreemarkerRender.replace((Elements)imgElements, (String)"src", (String)cdnDomain);
        Elements linkElements = doc.select("link[href]");
        JFreemarkerRender.replace((Elements)linkElements, (String)"href", (String)cdnDomain);
        return doc.toString();
    }

    public static void replace(Elements elements, String attrName, String cdnDomain) {
        for (Element element : elements) {
            String url = element.attr(attrName);
            if (JFreemarkerRender.isExcludeUrl((String)url)) continue;
            if (url != null && url.startsWith("/")) {
                url = cdnDomain + url;
            }
            element.attr(attrName, url);
        }
    }

    private static boolean isExcludeUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return false;
        }
        String cdn_exclude_files = OptionQuery.me().findValue("cdn_exclude_files");
        if (StringUtils.isNotBlank((String)cdn_exclude_files)) {
            String[] lines;
            if (cdn_exclude_files.contains(url) || url.contains("/counter")) {
                return true;
            }
            for (String regex : lines = cdn_exclude_files.split("\\n")) {
                if (!StringUtils.match((String)url, (String)regex)) continue;
                return true;
            }
        }
        return false;
    }
}

