/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.plugin.activerecord.Page;
import io.jpress.core.JBaseController;
import io.jpress.model.Content;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.router.RouterMapping;
import io.jpress.template.TemplateManager;
import io.jpress.utils.EncryptUtils;
import io.jpress.utils.StringUtils;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@RouterMapping(url="/api")
public class ApiController
extends JBaseController {
    public void index() {
        Boolean apiEnable;
        Boolean apiCorsEnable = OptionQuery.me().findValueAsBool("api_cors_enable");
        if (apiCorsEnable != null && apiCorsEnable.booleanValue()) {
            this.getResponse().setHeader("Access-Control-Allow-Origin", "*");
            this.getResponse().setHeader("Access-Control-Allow-Methods", "GET,POST");
        }
        if ((apiEnable = OptionQuery.me().findValueAsBool("api_enable")) == null || !apiEnable.booleanValue()) {
            this.renderAjaxResult("api is not open", 1);
            return;
        }
        String method = this.getPara("method");
        if (StringUtils.isBlank((String)method)) {
            this.renderAjaxResultForError("method must not empty!");
            return;
        }
        if (method.startsWith("query")) {
            this.doInvoke(method);
            return;
        }
        String appkey = this.getPara("appkey");
        if (StringUtils.isBlank((String)appkey)) {
            this.renderAjaxResultForError("appkey must not empty!");
            return;
        }
        Content content = ContentQuery.me().findFirstByModuleAndText("api_application", appkey);
        if (content == null) {
            this.renderAjaxResultForError("appkey is error!");
            return;
        }
        String appSecret = content.getFlag();
        String sign = this.getPara("sign");
        if (!StringUtils.isNotBlank((String)sign)) {
            this.renderAjaxResultForError("sign must not empty!");
            return;
        }
        String sign_method = this.getPara("sign_method");
        if (!StringUtils.isNotBlank((String)sign_method)) {
            this.renderAjaxResultForError("sign_method must not empty!");
            return;
        }
        HashMap params = new HashMap();
        Map oParams = this.getParaMap();
        if (oParams != null) {
            for (Map.Entry entry : oParams.entrySet()) {
                String value = entry.getValue() == null ? "" : (((String[])entry.getValue())[0] == null ? "" : ((String[])entry.getValue())[0]);
                params.put(entry.getKey(), value);
            }
        }
        params.remove("sign");
        String mySign = EncryptUtils.signForRequest(params, (String)appSecret);
        if (!sign.equals(mySign)) {
            this.renderAjaxResultForError("sign is error!");
            return;
        }
        this.doInvoke(method);
    }

    private void doInvoke(String method) {
        try {
            this.invoke(method);
        }
        catch (NoSuchMethodException e) {
            this.renderAjaxResultForError("hava no this method : " + method);
            return;
        }
        catch (Throwable e) {
            this.renderAjaxResultForError("system error!");
            return;
        }
    }

    private void invoke(String methodName) throws NoSuchMethodException, Throwable {
        Method method = ApiController.class.getDeclaredMethod(methodName, new Class[0]);
        if (method == null) {
            throw new NoSuchMethodException();
        }
        method.setAccessible(true);
        method.invoke((Object)this, new Object[0]);
    }

    private void queryTest() {
        this.renderAjaxResultForSuccess("test ok!");
    }

    private void queryContent() {
        BigInteger id = this.getParaToBigInteger("id");
        if (id == null) {
            this.renderAjaxResultForError("id is null");
            return;
        }
        Content c = ContentQuery.me().findById(id);
        if (c == null) {
            this.renderAjaxResultForError("can't find by id:" + id);
            return;
        }
        this.renderAjaxResult("success", 0, (Object)c);
    }

    private void queryContentPage() {
        int pagesize;
        int page = this.getParaToInt("page", Integer.valueOf(1));
        if (page < 1) {
            page = 1;
        }
        if ((pagesize = this.getParaToInt("pagesize", Integer.valueOf(10)).intValue()) < 1 || pagesize > 100) {
            pagesize = 10;
        }
        String[] modules = null;
        String modulesString = this.getPara("module");
        if (modulesString != null) {
            modules = modulesString.split(",");
            ArrayList<String> moduleList = new ArrayList<String>();
            for (int i = 0; i < modules.length; ++i) {
                String module = modules[i];
                if (TemplateManager.me().currentTemplateModule(modules[i]) == null) continue;
                moduleList.add(module);
            }
            if (!moduleList.isEmpty()) {
                modules = moduleList.toArray(new String[0]);
            }
        }
        if (modules == null) {
            modules = TemplateManager.me().currentTemplateModulesAsArray();
        }
        String keyword = this.getPara("keyword");
        String status = this.getPara("status");
        BigInteger[] taxonomyIds = null;
        String taxonomyIdString = this.getPara("taxonomyid");
        if (taxonomyIdString != null) {
            String[] taxonomyIdStrings = taxonomyIdString.split(",");
            ArrayList<BigInteger> ids = new ArrayList<BigInteger>();
            for (String idString : taxonomyIdStrings) {
                ids.add(new BigInteger(idString));
            }
            taxonomyIds = ids.toArray(new BigInteger[0]);
        }
        BigInteger userId = this.getParaToBigInteger("userid");
        String month = this.getPara("month");
        String orderBy = this.getPara("orderBy");
        Page contentPage = ContentQuery.me().paginate(page, pagesize, modules, keyword, status, taxonomyIds, userId, month, orderBy);
        this.renderAjaxResultForSuccess("success", (Object)contentPage);
    }
}

