/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.core.Controller;
import io.jpress.core.BaseFrontController;
import io.jpress.core.cache.ActionCacheManager;
import io.jpress.message.MessageKit;
import io.jpress.model.Comment;
import io.jpress.model.Content;
import io.jpress.model.User;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.model.query.UserQuery;
import io.jpress.router.RouterMapping;
import io.jpress.utils.CookieUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Date;

@RouterMapping(url="/comment")
public class CommentController
extends BaseFrontController {
    public void index() {
        this.renderError(404);
    }

    public void submit() {
        User user;
        BigInteger contentId;
        Boolean comment_need_captcha;
        String gotoUrl = this.getPara("goto");
        if (gotoUrl == null) {
            gotoUrl = this.getRequest().getHeader("Referer");
        }
        String anchor = this.getPara("anchor");
        if (gotoUrl != null && anchor != null) {
            gotoUrl = gotoUrl + "#" + anchor;
        }
        if ((comment_need_captcha = OptionQuery.me().findValueAsBool("comment_need_captcha")) != null && comment_need_captcha.booleanValue() && !this.validateCaptcha("comment_captcha")) {
            this.renderForCommentError("validate captcha fail", 1);
            return;
        }
        BigInteger userId = StringUtils.toBigInteger((String)CookieUtils.get((Controller)this, (String)"user"), null);
        Boolean comment_allow_not_login = OptionQuery.me().findValueAsBool("comment_allow_not_login");
        if (!(comment_allow_not_login != null && comment_allow_not_login.booleanValue() || userId != null)) {
            String redirect = "/user/login";
            if (StringUtils.isNotBlank((String)gotoUrl)) {
                redirect = redirect + "?goto=" + StringUtils.urlEncode((String)gotoUrl);
            }
            this.redirect(redirect);
            return;
        }
        String status = Comment.STATUS_NORMAL;
        Boolean comment_must_audited = OptionQuery.me().findValueAsBool("comment_must_audited");
        if (comment_must_audited != null && comment_must_audited.booleanValue()) {
            status = Comment.STATUS_DRAFT;
        }
        if ((contentId = this.getParaToBigInteger("cid")) == null) {
            this.renderForCommentError("comment fail,content id is null.", 1);
            return;
        }
        Content content = ContentQuery.me().findById(contentId);
        if (content == null) {
            this.renderForCommentError("find not find the content, maybe it has bean deleted.", 1);
            return;
        }
        if (!content.isCommentEnable()) {
            this.renderForCommentError("the comment function of the content has been closed.", 1);
            return;
        }
        String text = this.getPara("text");
        if (StringUtils.isBlank((String)text)) {
            this.renderForCommentError("comment fail,text is blank.", 2);
            return;
        }
        String author = this.getPara("author");
        String email = this.getPara("email");
        String ip = this.getIPAddress();
        String agent = this.getUserAgent();
        String type = "comment";
        if (userId != null && (user = UserQuery.me().findById(userId)) != null) {
            String string = author = StringUtils.isNotBlank((String)user.getNickname()) ? user.getNickname() : user.getUsername();
        }
        if (StringUtils.isBlank((String)author)) {
            String defautAuthor = OptionQuery.me().findValue("comment_default_nickname");
            author = StringUtils.isNotBlank((String)defautAuthor) ? defautAuthor : "\u7f51\u53cb";
        }
        BigInteger parentId = this.getParaToBigInteger("parent_id");
        Comment comment = new Comment();
        comment.setContentModule(content.getModule());
        comment.setType("comment");
        comment.setContentId(content.getId());
        comment.setText(text);
        comment.setIp(ip);
        comment.setAgent(agent);
        comment.setAuthor(author);
        comment.setEmail(email);
        comment.setType(type);
        comment.setStatus(status);
        comment.setUserId(userId);
        comment.setCreated(new Date());
        comment.setParentId(parentId);
        if (comment.save()) {
            MessageKit.sendMessage((String)"comment:add", (Object)comment);
            ActionCacheManager.clearCache();
        }
        if (this.isAjaxRequest()) {
            this.renderAjaxResultForSuccess();
            return;
        }
        if (gotoUrl != null) {
            this.redirect(gotoUrl);
            return;
        }
        this.renderText("comment ok");
    }

    private void renderForCommentError(String message, int errorCode) {
        String referer = this.getRequest().getHeader("Referer");
        if (this.isAjaxRequest()) {
            this.renderAjaxResult(message, errorCode);
        } else {
            this.redirect(referer + "#" + this.getPara("anchor"));
        }
    }
}

