/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.core.Controller;
import com.jfinal.render.Render;
import io.jpress.core.BaseFrontController;
import io.jpress.core.addon.HookInvoker;
import io.jpress.core.cache.ActionCache;
import io.jpress.front.controller.VisitorCounter;
import io.jpress.model.Content;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.router.RouterMapping;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.ui.freemarker.tag.CommentPageTag;
import io.jpress.ui.freemarker.tag.MenusTag;
import io.jpress.ui.freemarker.tag.NextContentTag;
import io.jpress.ui.freemarker.tag.PreviousContentTag;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.List;

@RouterMapping(url="/c")
public class ContentController
extends BaseFrontController {
    private String slug;
    private BigInteger id;
    private int page;

    @ActionCache
    public void index() {
        try {
            Render render = this.onRenderBefore();
            if (render != null) {
                this.render(render);
            } else {
                this.doRender();
            }
        }
        finally {
            this.onRenderAfter();
        }
    }

    private void doRender() {
        this.initRequest();
        Content content = this.queryContent();
        if (null == content) {
            this.renderError(404);
            return;
        }
        TplModule module = TemplateManager.me().currentTemplateModule(content.getModule());
        if (module == null) {
            this.renderError(404);
            return;
        }
        this.updateContentViewCount(content);
        this.setGlobleAttrs(content);
        this.setAttr("p", (Object)this.page);
        this.setAttr("content", (Object)content);
        this.setAttr("jp.next", (Object)new NextContentTag(content));
        this.setAttr("jp.previous", (Object)new PreviousContentTag(content));
        this.setAttr("jp.commentPage", (Object)new CommentPageTag(this.getRequest(), content, this.page));
        List taxonomys = TaxonomyQuery.me().findListByContentId(content.getId());
        this.setAttr("taxonomys", (Object)taxonomys);
        this.setAttr("jp.menus", (Object)new MenusTag(this.getRequest(), taxonomys, content));
        String style = content.getStyle();
        if (StringUtils.isNotBlank((String)style)) {
            this.render(String.format("content_%s_%s.html", module.getName(), style.trim()));
            return;
        }
        style = this.tryGetTaxonomyTemplate(module, taxonomys);
        if (style != null) {
            this.render(String.format("content_%s_%s.html", module.getName(), style));
            return;
        }
        this.render(String.format("content_%s.html", module.getName()));
    }

    private String tryGetTaxonomyTemplate(TplModule module, List<Taxonomy> taxonomys) {
        if (taxonomys == null || taxonomys.isEmpty()) {
            return null;
        }
        String forSlug = null;
        for (Taxonomy taxonomy : taxonomys) {
            String tFile = String.format("content_%s_%s%s.html", module.getName(), "for$", taxonomy.getSlug());
            if (!this.templateExists(tFile)) continue;
            if (forSlug == null) {
                forSlug = "for$" + taxonomy.getSlug();
                continue;
            }
            forSlug = null;
            break;
        }
        return forSlug;
    }

    private void updateContentViewCount(Content content) {
        long visitorCount = VisitorCounter.getVisitorCount((BigInteger)content.getId());
        Long viewCount = content.getViewCount() == null ? visitorCount : content.getViewCount() + visitorCount;
        content.setViewCount(viewCount);
        if (content.update()) {
            VisitorCounter.clearVisitorCount((BigInteger)content.getId());
        }
    }

    private void setGlobleAttrs(Content content) {
        this.setAttr("WEB_TITLE", (Object)content.getTitle());
        if (StringUtils.isNotBlank((String)content.getMetaKeywords())) {
            this.setAttr("META_KEYWORDS", (Object)content.getMetaKeywords());
        } else {
            this.setAttr("META_KEYWORDS", (Object)content.getTaxonomyAsString(null));
        }
        if (StringUtils.isNotBlank((String)content.getMetaDescription())) {
            this.setAttr("META_DESCRIPTION", (Object)content.getMetaDescription());
        } else {
            this.setAttr("META_DESCRIPTION", (Object)content.getSummary());
        }
    }

    private Content queryContent() {
        if (this.id != null) {
            return ContentQuery.me().findById(this.id);
        }
        return ContentQuery.me().findBySlug(StringUtils.urlDecode((String)this.slug));
    }

    private void initRequest() {
        String para = this.getPara(0);
        if (StringUtils.isBlank((String)para)) {
            this.id = this.getParaToBigInteger("id");
            this.slug = this.getPara("slug");
            this.page = this.getParaToInt("p", Integer.valueOf(1));
            if (this.id == null && this.slug == null) {
                this.renderError(404);
            }
            return;
        }
        if (StringUtils.isNumeric((String)para)) {
            this.id = new BigInteger(para);
        } else {
            this.slug = para;
        }
        this.page = this.getParaToInt(1, Integer.valueOf(1));
    }

    private Render onRenderBefore() {
        return HookInvoker.contentRenderBefore((Controller)this);
    }

    private void onRenderAfter() {
        HookInvoker.contentRenderAfter((Controller)this);
    }
}

