/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.core.Controller;
import com.jfinal.render.Render;
import io.jpress.core.BaseFrontController;
import io.jpress.core.addon.HookInvoker;
import io.jpress.core.cache.ActionCache;
import io.jpress.model.query.OptionQuery;
import io.jpress.router.RouterMapping;
import io.jpress.ui.freemarker.tag.IndexPageTag;
import io.jpress.utils.StringUtils;

@RouterMapping(url="/")
public class IndexController
extends BaseFrontController {
    @ActionCache
    public void index() {
        try {
            Render render = this.onRenderBefore();
            if (render != null) {
                this.render(render);
            } else {
                this.doRender();
            }
        }
        finally {
            this.onRenderAfter();
        }
    }

    private void doRender() {
        this.setGlobleAttrs();
        String para = this.getPara();
        if (StringUtils.isBlank((String)para)) {
            this.setAttr("jp.indexPage", (Object)new IndexPageTag(this.getRequest(), null, 1, null));
            this.render("index.html");
            return;
        }
        String[] paras = para.split("-");
        if (paras.length == 1) {
            if (StringUtils.isNumeric((String)para.trim())) {
                this.setAttr("jp.indexPage", (Object)new IndexPageTag(this.getRequest(), null, StringUtils.toInt((String)para.trim(), (int)1), null));
                this.render("index.html");
            } else {
                this.setAttr("jp.indexPage", (Object)new IndexPageTag(this.getRequest(), para.trim(), 1, null));
                this.render("page_" + para + ".html");
            }
        } else if (paras.length == 2) {
            String pageName = paras[0];
            String pageNumber = paras[1];
            if (!StringUtils.isNumeric((String)pageNumber)) {
                this.renderError(404);
            }
            this.setAttr("jp.indexPage", (Object)new IndexPageTag(this.getRequest(), pageName, StringUtils.toInt((String)pageNumber, (int)1), null));
            this.render("page_" + pageName + ".html");
        } else {
            this.renderError(404);
        }
    }

    private void setGlobleAttrs() {
        String title = OptionQuery.me().findValue("seo_index_title");
        String keywords = OptionQuery.me().findValue("seo_index_keywords");
        String description = OptionQuery.me().findValue("seo_index_description");
        if (StringUtils.isNotBlank((String)title)) {
            this.setAttr("WEB_TITLE", (Object)title);
        }
        if (StringUtils.isNotBlank((String)keywords)) {
            this.setAttr("META_KEYWORDS", (Object)keywords);
        }
        if (StringUtils.isNotBlank((String)description)) {
            this.setAttr("META_DESCRIPTION", (Object)description);
        }
    }

    private Render onRenderBefore() {
        return HookInvoker.indexRenderBefore((Controller)this);
    }

    private void onRenderAfter() {
        HookInvoker.indexRenderAfter((Controller)this);
    }
}

