/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.core.Controller;
import io.jpress.message.MessageKit;
import io.jpress.model.Metadata;
import io.jpress.model.User;
import io.jpress.model.query.OptionQuery;
import io.jpress.model.query.UserQuery;
import io.jpress.oauth2.Oauth2Controller;
import io.jpress.oauth2.OauthConnector;
import io.jpress.oauth2.OauthUser;
import io.jpress.oauth2.connector.FacebookConnector;
import io.jpress.oauth2.connector.GithubConnector;
import io.jpress.oauth2.connector.LinkedinConnector;
import io.jpress.oauth2.connector.OSChinaConnector;
import io.jpress.oauth2.connector.QQConnector;
import io.jpress.oauth2.connector.TwitterConnector;
import io.jpress.oauth2.connector.WechatConnector;
import io.jpress.oauth2.connector.WeiboConnector;
import io.jpress.router.RouterMapping;
import io.jpress.utils.CookieUtils;
import io.jpress.utils.EncryptUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
@RouterMapping(url="/oauth")
public class OauthController
extends Oauth2Controller {
    private static final Map<String, OauthConnector> connectorMap = new HashMap();

    public void index() {
        String gotoUrl = this.getPara("goto");
        if (StringUtils.isNotBlank((String)gotoUrl)) {
            this.setSessionAttr("_goto_url", (Object)gotoUrl);
        }
        super.index();
    }

    public void onAuthorizeSuccess(OauthUser ouser) {
        User user = UserQuery.me().findFirstFromMetadata(ouser.getSource() + "_open_id", (Object)ouser.getOpenId());
        if (null == user) {
            user = new User();
            user.setAvatar(ouser.getAvatar());
            user.setNickname(ouser.getNickname());
            user.setCreateSource(ouser.getSource());
            user.setCreated(new Date());
            user.setGender(ouser.getGender());
            user.setSalt(EncryptUtils.salt());
            user.save();
            MessageKit.sendMessage((String)"user:created", (Object)user);
            BigInteger userId = user.getId();
            if (userId != null && userId.compareTo(BigInteger.ZERO) > 0) {
                Metadata md = user.createMetadata();
                md.setMetaKey(ouser.getSource() + "_open_id");
                md.setMetaValue(ouser.getOpenId());
                md.saveOrUpdate();
            }
        }
        this.doAuthorizeSuccess(user);
    }

    public void onAuthorizeError(String errorMessage) {
        String redirect = this.getPara("goto");
        redirect = StringUtils.isNotBlank((String)redirect) ? redirect : "/user/login";
        this.redirect(redirect);
    }

    private void doAuthorizeSuccess(User user) {
        CookieUtils.put((Controller)this, (String)"user", (BigInteger)user.getId());
        MessageKit.sendMessage((String)"user:logined", (Object)user);
        String redirect = this.getPara("goto");
        if (StringUtils.isBlank((String)redirect)) {
            redirect = (String)this.getSessionAttr("_goto_url");
        }
        redirect = StringUtils.isNotBlank((String)redirect) ? StringUtils.urlRedirect((String)redirect) : "/user/center";
        this.redirect(redirect);
    }

    public OauthConnector onConnectorGet(String processerName) {
        String appkey = OptionQuery.me().findValue("oauth2_" + processerName + "_appkey");
        String appsecret = OptionQuery.me().findValue("oauth2_" + processerName + "_appsecret");
        return OauthController.getConnector((String)processerName, (String)appkey, (String)appsecret);
    }

    private static OauthConnector getConnector(String name, String appkey, String appSecret) {
        OauthConnector connector = (OauthConnector)connectorMap.get(name);
        if (connector == null) {
            if ("qq".equals(name)) {
                connector = new QQConnector(name, appkey, appSecret);
            } else if ("wechat".equals(name)) {
                connector = new WechatConnector(name, appkey, appSecret);
            } else if ("weibo".equals(name)) {
                connector = new WeiboConnector(name, appkey, appSecret);
            } else if ("oschina".equals(name)) {
                connector = new OSChinaConnector(name, appkey, appSecret);
            } else if ("github".equals(name)) {
                connector = new GithubConnector(name, appkey, appSecret);
            } else if ("facebook".equals(name)) {
                connector = new FacebookConnector(name, appkey, appSecret);
            } else if ("twitter".equals(name)) {
                connector = new TwitterConnector(name, appkey, appSecret);
            } else if ("linkedin".equals(name)) {
                connector = new LinkedinConnector(name, appkey, appSecret);
            }
            if (connector != null) {
                connectorMap.put(name, connector);
            }
        }
        return connector;
    }
}

