/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.core.Controller;
import io.jpress.core.cache.ActionCache;
import io.jpress.model.Content;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.router.RouterMapping;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.List;

@RouterMapping(url="/rss")
public class RssController
extends Controller {
    private static final String contentType = "text/xml; charset=UTF-8";
    private String title;
    private String description;
    private String link;
    private String webTitle;
    private String webLink;
    private String webLogo;
    private BigInteger taxonomyId;

    @ActionCache
    public void index() {
        this.doInit();
        this.doRender();
    }

    private void doInit() {
        String para = this.getPara();
        if (StringUtils.isNotBlank((String)para)) {
            this.taxonomyId = new BigInteger(para);
        }
        this.webTitle = OptionQuery.me().findValue("web_title");
        if (StringUtils.isBlank((String)this.webTitle)) {
            this.webTitle = OptionQuery.me().findValue("web_name");
        }
        this.webLink = OptionQuery.me().findValue("web_domain");
        this.webLogo = OptionQuery.me().findValue("web_logo");
        if (this.webLogo == null) {
            this.webLogo = "";
        }
        if (this.taxonomyId == null) {
            this.title = this.webTitle;
            this.link = this.webLink;
            this.description = OptionQuery.me().findValue("web_subtitle");
        } else {
            Taxonomy taxonomy = TaxonomyQuery.me().findById(this.taxonomyId);
            if (taxonomy != null) {
                this.title = taxonomy.getTitle();
                this.description = taxonomy.getText();
                this.link = this.webLink + taxonomy.getUrl();
            }
        }
    }

    private void doRender() {
        StringBuilder xmlBuilder = new StringBuilder();
        this.buildChannelHeader(xmlBuilder);
        this.buildChannelInfo(xmlBuilder);
        List clist = null;
        clist = this.taxonomyId != null ? ContentQuery.me().findListInNormal(1, 20, this.taxonomyId) : ContentQuery.me().findListInNormal(1, 20);
        if (clist != null && !clist.isEmpty()) {
            for (Content content : clist) {
                this.buildChannelItem(xmlBuilder, content);
            }
        }
        this.buildChannelFooter(xmlBuilder);
        this.renderText(xmlBuilder.toString(), contentType);
    }

    private void buildChannelHeader(StringBuilder xmlBuilder) {
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlBuilder.append("<rss version=\"2.0\">");
        xmlBuilder.append("<channel>");
    }

    private void buildChannelFooter(StringBuilder xmlBuilder) {
        xmlBuilder.append("</channel>");
        xmlBuilder.append("</rss>");
        xmlBuilder.append("<!-- This rss was generated by JPress --> ");
    }

    private void buildChannelInfo(StringBuilder xmlBuilder) {
        xmlBuilder.append("<title>" + this.title + "</title>");
        xmlBuilder.append("<description>" + this.description + "</description>");
        xmlBuilder.append("<link>" + this.link + "</link>");
        xmlBuilder.append("<generator>JPress (http://www.jpress.io) </generator>");
        xmlBuilder.append("<image>");
        xmlBuilder.append("<url>" + this.webLogo + "</url>");
        xmlBuilder.append("<title>" + this.webTitle + "</title>");
        xmlBuilder.append("<link>" + this.webLink + "</link>");
        xmlBuilder.append("</image>");
    }

    private void buildChannelItem(StringBuilder xmlBuilder, Content content) {
        xmlBuilder.append("<item>");
        xmlBuilder.append("<title><![CDATA[ " + content.getTitle() + " ]]></title>");
        xmlBuilder.append("<link>" + this.webLink + content.getUrl() + "</link>");
        xmlBuilder.append("<description><![CDATA[ " + content.getText() + " ]]></description>");
        xmlBuilder.append("<source>" + this.webTitle + "</source>");
        xmlBuilder.append("<pubDate>" + content.getModified() + "</pubDate>");
        xmlBuilder.append("</item>");
    }
}

