/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.core.Controller;
import io.jpress.core.cache.ActionCache;
import io.jpress.model.Content;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.router.RouterMapping;
import io.jpress.utils.DateUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@RouterMapping(url="/sitemap")
public class SitemapController
extends Controller {
    private static final String contentType = "text/xml; charset=UTF-8";
    static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:ss:mm'Z'");

    @ActionCache
    public void index() {
        StringBuilder xmlBuilder = new StringBuilder();
        this.buildSitemapHeader(xmlBuilder);
        String domain = OptionQuery.me().findValue("web_domain");
        if (StringUtils.isBlank((String)domain)) {
            domain = "";
        }
        this.buildSitemap(xmlBuilder, domain + "/sitemap/site", format.format(new Date()));
        List taxonomys = TaxonomyQuery.me().findAll();
        if (taxonomys != null && !taxonomys.isEmpty()) {
            for (Taxonomy t : taxonomys) {
                this.buildSitemap(xmlBuilder, domain + "/sitemap/taxonomy/" + t.getId(), format.format(new Date()));
            }
        }
        this.buildSitemapFooter(xmlBuilder);
        this.renderText(xmlBuilder.toString(), contentType);
    }

    @ActionCache
    public void site() {
        StringBuilder xmlBuilder = new StringBuilder();
        this.buildUrlsetHeader(xmlBuilder);
        this.buildUrl(xmlBuilder, OptionQuery.me().findValue("web_domain"), format.format(new Date()), "always", "1.0");
        this.buildUrlsetFooter(xmlBuilder);
        this.renderText(xmlBuilder.toString(), contentType);
    }

    @ActionCache
    public void taxonomy() {
        String idString = this.getPara();
        if (StringUtils.isBlank((String)idString)) {
            this.renderText("", contentType);
        }
        BigInteger id = new BigInteger(idString);
        StringBuilder xmlBuilder = new StringBuilder();
        this.buildUrlsetHeader(xmlBuilder);
        String domain = OptionQuery.me().findValue("web_domain");
        List contents = ContentQuery.me().findListInNormal(1, 500, id);
        if (contents != null && !contents.isEmpty()) {
            for (Content c : contents) {
                if (c.getModified() == null) continue;
                String changefreq = "daily";
                String priority = "1.0";
                int dayDiff = DateUtils.getDayDiff((Date)new Date(), (Date)c.getModified());
                if (dayDiff > 30) {
                    changefreq = "monthly";
                    priority = "0.3";
                } else if (dayDiff > 7) {
                    changefreq = "weekly";
                    priority = "0.9";
                }
                this.buildUrl(xmlBuilder, domain + c.getUrl(), format.format(c.getModified()), changefreq, priority);
            }
        }
        this.buildUrlsetFooter(xmlBuilder);
        this.renderText(xmlBuilder.toString(), contentType);
    }

    private void buildSitemapHeader(StringBuilder xmlBuilder) {
        this.buildHeader(xmlBuilder);
        xmlBuilder.append("<sitemapindex ");
        xmlBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        xmlBuilder.append(" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9\" ");
        xmlBuilder.append(" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" ");
        xmlBuilder.append(" > ");
    }

    private void buildSitemapFooter(StringBuilder xmlBuilder) {
        xmlBuilder.append("</sitemapindex>");
        this.buildFooter(xmlBuilder);
    }

    private void buildUrlsetHeader(StringBuilder xmlBuilder) {
        this.buildHeader(xmlBuilder);
        xmlBuilder.append("<urlset");
        xmlBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        xmlBuilder.append(" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9\" ");
        xmlBuilder.append(" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" ");
        xmlBuilder.append(" > ");
    }

    private void buildUrlsetFooter(StringBuilder xmlBuilder) {
        xmlBuilder.append("</urlset>");
        this.buildFooter(xmlBuilder);
    }

    private void buildHeader(StringBuilder xmlBuilder) {
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    private void buildFooter(StringBuilder xmlBuilder) {
        xmlBuilder.append("<!-- This sitemap was generated by JPress --> ");
    }

    private void buildSitemap(StringBuilder xmlBuilder, String loc, String lastmod) {
        xmlBuilder.append("<sitemap>");
        xmlBuilder.append("<loc>" + loc + "</loc>");
        xmlBuilder.append("<lastmod>" + lastmod + "</lastmod>");
        xmlBuilder.append("</sitemap>");
    }

    private void buildUrl(StringBuilder xmlBuilder, String loc, String lastmod, String changefreq, String priority) {
        xmlBuilder.append("<url>");
        xmlBuilder.append("<loc>" + loc + "</loc>");
        xmlBuilder.append("<lastmod>" + lastmod + "</lastmod>");
        xmlBuilder.append("<changefreq>" + changefreq + "</changefreq>");
        xmlBuilder.append("<priority>" + priority + "</priority>");
        xmlBuilder.append("</url>");
    }
}

