/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.core.Controller;
import com.jfinal.render.Render;
import io.jpress.core.BaseFrontController;
import io.jpress.core.addon.HookInvoker;
import io.jpress.core.cache.ActionCache;
import io.jpress.model.Content;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.router.RouterMapping;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.ui.freemarker.tag.ContentPageTag;
import io.jpress.ui.freemarker.tag.MenusTag;
import io.jpress.ui.freemarker.tag.TaxonomysTag;
import io.jpress.utils.StringUtils;
import java.util.List;

@RouterMapping(url="/t")
public class TaxonomyController
extends BaseFrontController {
    protected TplModule module;
    protected String[] slugs;
    protected Integer page;

    @ActionCache
    public void index() {
        try {
            Render render = this.onRenderBefore();
            if (render != null) {
                this.render(render);
            } else {
                this.doRender();
            }
        }
        finally {
            this.onRenderAfter();
        }
    }

    private void doRender() {
        String order;
        this.initRequest();
        List taxonomys = this.tryGetTaxonomy();
        if (this.slugs != null && this.slugs.length > 0 && taxonomys == null) {
            this.renderError(404);
        }
        Taxonomy taxonomy = null;
        if (taxonomys != null && !taxonomys.isEmpty()) {
            taxonomy = (Taxonomy)taxonomys.get(0);
        }
        this.setAttr("_page_number", (Object)this.page);
        this.setAttr("taxonomys", (Object)taxonomys);
        this.setAttr("taxonomy", (Object)taxonomy);
        this.setAttr("module", (Object)this.module);
        this.setGlobleAttrs(taxonomys);
        this.setAttr("jp.menus", (Object)new MenusTag(this.getRequest(), taxonomys, null));
        this.setAttr("jp.taxonomys", (Object)new TaxonomysTag(taxonomys));
        if (taxonomy != null) {
            Content c = ContentQuery.me().findFirstByModuleAndObjectId("menu", taxonomy.getId());
            this.setAttr("currentMenu", (Object)c);
        }
        if (this.module.isSupportOrder(order = this.getPara("order"))) {
            this.setAttr("jp.contentPage", (Object)new ContentPageTag(this.getRequest(), this.page.intValue(), this.module.getName(), taxonomys, order));
        } else {
            this.setAttr("jp.contentPage", (Object)new ContentPageTag(this.getRequest(), this.page.intValue(), this.module.getName(), taxonomys, null));
        }
        if (taxonomys == null || taxonomys.size() != 1) {
            this.render(String.format("taxonomy_%s.html", this.module.getName()));
        } else {
            this.render(String.format("taxonomy_%s_%s.html", this.module.getName(), ((Taxonomy)taxonomys.get(0)).getSlug()));
        }
    }

    private void setGlobleAttrs(List<Taxonomy> taxonomys) {
        if (taxonomys == null || taxonomys.isEmpty()) {
            return;
        }
        StringBuffer title = new StringBuffer();
        StringBuffer keywords = new StringBuffer();
        StringBuffer description = new StringBuffer();
        for (Taxonomy taxonomy : taxonomys) {
            title.append(taxonomy.getTitle()).append("-");
            keywords.append(taxonomy.getMetaKeywords()).append(",");
            description.append(taxonomy.getMetaDescription()).append(";");
        }
        title.deleteCharAt(title.length() - 1);
        keywords.deleteCharAt(keywords.length() - 1);
        description.deleteCharAt(description.length() - 1);
        this.setAttr("WEB_TITLE", (Object)title.toString());
        this.setAttr("META_KEYWORDS", (Object)keywords.toString());
        this.setAttr("META_DESCRIPTION", (Object)description.toString());
    }

    private List<Taxonomy> tryGetTaxonomy() {
        return this.slugs == null || this.slugs.length == 0 ? null : TaxonomyQuery.me().findBySlugAndModule(this.slugs, this.module.getName());
    }

    private void initRequest() {
        int paraCount;
        String moduleName = this.getPara(0);
        if (StringUtils.isBlank((String)moduleName)) {
            this.renderError(404);
        }
        this.module = TemplateManager.me().currentTemplateModule(moduleName);
        if (this.module == null) {
            this.renderError(404);
        }
        if ((paraCount = this.getParaCount()) == 1) {
            this.page = 1;
        }
        String slugStrings = null;
        if (paraCount >= 2) {
            for (int i = 1; i < paraCount; ++i) {
                String para = this.getPara(i);
                if (StringUtils.isNumeric((String)para)) {
                    this.page = StringUtils.toInt((String)para, (int)1);
                    if (i == paraCount - 1) continue;
                    this.renderError(404);
                    continue;
                }
                slugStrings = StringUtils.urlDecode((String)para);
            }
        }
        if (StringUtils.isNotBlank(slugStrings)) {
            this.slugs = slugStrings.split(",");
        }
        if (this.page == null || this.page <= 0) {
            this.page = 1;
        }
    }

    private Render onRenderBefore() {
        return HookInvoker.taxonomyRenderBefore((Controller)this);
    }

    private void onRenderAfter() {
        HookInvoker.taxonomyRenderAfter((Controller)this);
    }
}

