/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.front.controller;

import com.jfinal.aop.Before;
import com.jfinal.aop.Clear;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import io.jpress.core.BaseFrontController;
import io.jpress.interceptor.UCodeInterceptor;
import io.jpress.interceptor.UserInterceptor;
import io.jpress.message.MessageKit;
import io.jpress.model.User;
import io.jpress.model.query.UserQuery;
import io.jpress.router.RouterMapping;
import io.jpress.ui.freemarker.tag.UserContentPageTag;
import io.jpress.utils.CookieUtils;
import io.jpress.utils.EncryptUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Date;

@RouterMapping(url="/user")
@Before(value={UserInterceptor.class})
public class UserController
extends BaseFrontController {
    @Clear(value={UserInterceptor.class})
    public void index() {
        String action = this.getPara();
        if (StringUtils.isBlank((String)action)) {
            this.renderError(404);
        }
        this.keepPara();
        BigInteger userId = StringUtils.toBigInteger((String)action, null);
        if (userId != null) {
            User user = UserQuery.me().findById(userId);
            if (user != null) {
                this.setAttr("user", (Object)user);
                this.render(String.format("user_detail.html", action));
            } else {
                this.renderError(404);
            }
        } else {
            if ("detail".equalsIgnoreCase(action)) {
                this.renderError(404);
            }
            this.render(String.format("user_%s.html", action));
        }
    }

    @Clear(value={UserInterceptor.class})
    @ActionKey(value="/user/login")
    public void login() {
        this.keepPara();
        String username = this.getPara("username");
        String password = this.getPara("password");
        if (username == null || password == null) {
            this.render("user_login.html");
            return;
        }
        long errorTimes = CookieUtils.getLong((Controller)this, (String)"_login_errors", (int)0);
        if (errorTimes >= 3L && !this.validateCaptcha("_login_captcha")) {
            if (this.isAjaxRequest()) {
                this.renderAjaxResultForError("\u6ca1\u6709\u8be5\u7528\u6237");
            } else {
                this.redirect("/user/login");
            }
            return;
        }
        User user = UserQuery.me().findUserByUsername(username);
        if (null == user) {
            if (this.isAjaxRequest()) {
                this.renderAjaxResultForError("\u6ca1\u6709\u8be5\u7528\u6237");
            } else {
                this.setAttr("errorMsg", (Object)"\u6ca1\u6709\u8be5\u7528\u6237");
                this.render("user_login.html");
            }
            CookieUtils.put((Controller)this, (String)"_login_errors", (long)(errorTimes + 1L));
            return;
        }
        if (EncryptUtils.verlifyUser((String)user.getPassword(), (String)user.getSalt(), (String)password)) {
            MessageKit.sendMessage((String)"user:logined", (Object)user);
            CookieUtils.put((Controller)this, (String)"user", (BigInteger)user.getId());
            if (this.isAjaxRequest()) {
                this.renderAjaxResultForSuccess("\u767b\u9646\u6210\u529f");
            } else {
                String gotoUrl = this.getPara("goto");
                if (StringUtils.isNotEmpty((String)gotoUrl)) {
                    gotoUrl = StringUtils.urlDecode((String)gotoUrl);
                    gotoUrl = StringUtils.urlRedirect((String)gotoUrl);
                    this.redirect(gotoUrl);
                } else {
                    this.redirect("/user/center");
                }
            }
        } else {
            if (this.isAjaxRequest()) {
                this.renderAjaxResultForError("\u5bc6\u7801\u9519\u8bef");
            } else {
                this.setAttr("errorMsg", (Object)"\u5bc6\u7801\u9519\u8bef");
                this.render("user_login.html");
            }
            CookieUtils.put((Controller)this, (String)"_login_errors", (long)(errorTimes + 1L));
        }
    }

    @Before(value={UCodeInterceptor.class})
    public void logout() {
        CookieUtils.remove((Controller)this, (String)"user");
        this.redirect("/");
    }

    @Clear(value={UserInterceptor.class})
    public void doRegister() {
        if (!this.validateCaptcha("_register_captcha")) {
            this.renderForRegister("not validate captcha", 1);
            return;
        }
        this.keepPara();
        String username = this.getPara("username");
        String email = this.getPara("email");
        String mobile = this.getPara("mobile");
        String password = this.getPara("password");
        String confirm_password = this.getPara("confirm_password");
        if (StringUtils.isBlank((String)username)) {
            this.renderForRegister("username is empty!", 2);
            return;
        }
        if (!StringUtils.isNotBlank((String)email)) {
            this.renderForRegister("email is empty!", 4);
            return;
        }
        email = email.toLowerCase();
        if (!StringUtils.isNotBlank((String)password)) {
            this.renderForRegister("password is empty!", 8);
            return;
        }
        if (StringUtils.isNotEmpty((String)confirm_password) && !confirm_password.equals(password)) {
            this.renderForRegister("password is not equals confirm_password!", 8);
            return;
        }
        if (UserQuery.me().findUserByUsername(username) != null) {
            this.renderForRegister("username has exist!", 3);
            return;
        }
        if (UserQuery.me().findUserByEmail(email) != null) {
            this.renderForRegister("email has exist!", 5);
            return;
        }
        if (null != mobile && UserQuery.me().findUserByMobile(mobile) != null) {
            this.renderForRegister("phone has exist!", 7);
            return;
        }
        User user = new User();
        user.setUsername(username);
        user.setNickname(username);
        user.setEmail(email);
        user.setMobile(mobile);
        String salt = EncryptUtils.salt();
        password = EncryptUtils.encryptPassword((String)password, (String)salt);
        user.setPassword(password);
        user.setSalt(salt);
        user.setCreateSource("register");
        user.setCreated(new Date());
        if (user.save()) {
            CookieUtils.put((Controller)this, (String)"user", (BigInteger)user.getId());
            MessageKit.sendMessage((String)"user:created", (Object)user);
            if (this.isAjaxRequest()) {
                this.renderAjaxResultForSuccess();
            } else {
                String gotoUrl = this.getPara("goto");
                if (StringUtils.isNotEmpty((String)gotoUrl)) {
                    gotoUrl = StringUtils.urlDecode((String)gotoUrl);
                    gotoUrl = StringUtils.urlRedirect((String)gotoUrl);
                    this.redirect(gotoUrl);
                } else {
                    this.redirect("/user/center");
                }
            }
        } else {
            this.renderAjaxResultForError();
        }
    }

    private void renderForRegister(String message, int errorCode) {
        String referer = this.getRequest().getHeader("Referer");
        if (this.isAjaxRequest()) {
            this.renderAjaxResult(message, errorCode);
        } else {
            this.redirect(referer + "?errorcode=" + errorCode);
        }
    }

    public void center() {
        this.keepPara();
        String action = this.getPara(0, "index");
        this.render(String.format("user_center_%s.html", action));
        int pageNumber = this.getParaToInt(1, Integer.valueOf(1));
        BigInteger userId = this.getLoginedUser().getId();
        this.setAttr("jp.userContentPage", (Object)new UserContentPageTag(action, userId, pageNumber));
        this.setAttr("action", (Object)action);
        this.setAttr(action, (Object)"active");
    }
}

