/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.install;

import com.jfinal.kit.PathKit;
import com.jfinal.kit.PropKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.druid.DruidPlugin;
import com.jfinal.render.FreeMarkerRender;
import io.jpress.core.db.DbDialect;
import io.jpress.core.db.DbDialectFactory;
import io.jpress.utils.DateUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class InstallUtils {
    private static final Log log = Log.getLog(InstallUtils.class);
    private static String dbHost;
    private static String dbHostPort;
    private static String dbName;
    private static String dbUser;
    private static String dbPassword;
    public static String dbTablePrefix;
    public static DbDialect mDialect;

    public static void init(String db_host, String db_host_port, String db_name, String db_user, String db_password, String db_tablePrefix) {
        dbHost = db_host;
        dbHostPort = db_host_port;
        dbName = db_name;
        dbUser = db_user;
        dbPassword = db_password;
        dbTablePrefix = db_tablePrefix;
        mDialect = DbDialectFactory.getDbDialect();
    }

    public static boolean createDbProperties() {
        Properties p = new Properties();
        p.put("db_host", dbHost);
        p.put("db_host_port", dbHostPort);
        p.put("db_name", dbName);
        p.put("db_user", dbUser);
        p.put("db_password", dbPassword);
        p.put("db_tablePrefix", dbTablePrefix);
        File pFile = new File(PathKit.getRootClassPath(), "db.properties");
        return InstallUtils.save((Properties)p, (File)pFile);
    }

    public static boolean createJpressProperties() {
        Properties p = PropKit.use((String)"jpress.properties").getProperties();
        p.put("dev_mode", "false");
        p.put("encrypt_key", UUID.randomUUID().toString());
        File pFile = new File(PathKit.getRootClassPath(), "jpress.properties");
        return InstallUtils.save((Properties)p, (File)pFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean save(Properties p, File pFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pFile);
            p.store(fos, "Auto create by JPress");
        }
        catch (Exception e) {
            log.warn("InstallUtils save erro", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    public static List<String> getTableList() throws SQLException {
        DruidPlugin dp = InstallUtils.createDruidPlugin();
        Connection conn = dp.getDataSource().getConnection();
        List tableList = InstallUtils.query((Connection)conn, (String)mDialect.forShowTable());
        conn.close();
        dp.stop();
        return tableList;
    }

    public static void createJpressDatabase() throws SQLException {
        String installSql = mDialect.forInstall(dbTablePrefix);
        DruidPlugin dp = InstallUtils.createDruidPlugin();
        Connection conn = dp.getDataSource().getConnection();
        InstallUtils.executeBatchSql((Connection)conn, (String)installSql);
        conn.close();
        dp.stop();
    }

    public static void setWebName(String webName) throws SQLException {
        InstallUtils.executeSQL((String)mDialect.forInsertWebName(dbTablePrefix), (Object[])new Object[]{webName});
    }

    public static void setWebFirstUser(String username, String password, String salt) throws SQLException {
        InstallUtils.executeSQL((String)mDialect.forInsertFirstUser(dbTablePrefix), (Object[])new Object[]{username, password, salt, "administrator", "activited", DateUtils.now()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSQL(String sql, Object ... params) throws SQLException {
        DruidPlugin dp = InstallUtils.createDruidPlugin();
        Connection conn = dp.getDataSource().getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            if (null != params && params.length > 0) {
                int i = 0;
                for (Object param : params) {
                    pstmt.setString(++i, param.toString());
                }
            }
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            log.warn("InstallUtils executeSQL erro", (Throwable)e);
        }
        finally {
            pstmt.close();
            conn.close();
            dp.stop();
        }
    }

    private static void executeBatchSql(Connection conn, String batchSql) throws SQLException {
        Statement pst = conn.createStatement();
        if (null == batchSql) {
            throw new SQLException("SQL IS NULL");
        }
        if (batchSql.contains(";")) {
            String[] sqls;
            for (String sql : sqls = batchSql.split(";")) {
                if (null == sql || "".equals(sql.trim())) continue;
                pst.addBatch(sql);
            }
        } else {
            pst.addBatch(batchSql);
        }
        pst.executeBatch();
        InstallUtils.close((Statement)pst);
    }

    private static <T> List<T> query(Connection conn, String sql) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        PreparedStatement pst = conn.prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        int colAmount = rs.getMetaData().getColumnCount();
        if (colAmount > 1) {
            while (rs.next()) {
                Object[] temp = new Object[colAmount];
                for (int i = 0; i < colAmount; ++i) {
                    temp[i] = rs.getObject(i + 1);
                }
                result.add(temp);
            }
        } else if (colAmount == 1) {
            while (rs.next()) {
                result.add(rs.getObject(1));
            }
        }
        InstallUtils.close((ResultSet)rs, (Statement)pst);
        return result;
    }

    private static final void close(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static final void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static DruidPlugin createDruidPlugin() {
        DruidPlugin plugin = mDialect.createDuidPlugin(dbHost, dbHostPort, dbName, dbUser, dbPassword);
        plugin.start();
        return plugin;
    }

    public static void renderInstallFinished(HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        isHandled[0] = true;
        new FreeMarkerRender("/WEB-INF/install/finished.html").setContext(request, response).render();
    }
}

